/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.bootstrap;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.profileservice.domain.AbstractDomainMetaData;
import org.jboss.profileservice.domain.spi.DomainMetaData;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragment;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragmentVisitor;
import org.jboss.profileservice.domain.spi.DomainMetaDataRepository;
import org.jboss.profileservice.profile.metadata.BasicSubProfileMetaData;
import org.jboss.profileservice.profile.metadata.helpers.AbstractProfileMetaData;
import org.jboss.profileservice.profile.metadata.helpers.ProfileMetaDataFactory;
import org.jboss.profileservice.profile.metadata.plugin.ScanPeriod;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticBootstrapProfileFactory
implements DomainMetaDataFragment,
DomainMetaDataRepository {
    private String bindingsName = "jboss:profile=bindings";
    private String bootstrapName = "jboss:profile=legacy-service-xml";
    private String deployersName = "jboss:profile=deployers";
    private String applicationsName = "jboss:profile=applications";
    private String bindingsDeployment = "bindingservice.beans";
    private String bootstrapDeployment = "jboss-service.xml";
    private URI confURI;
    private URI deployersURI;
    private List<URI> applicationURIs;
    private ScanPeriod scanPeriod = new ScanPeriod();
    private File attachmentStoreRoot;

    public String getBootstrapName() {
        return this.bootstrapName;
    }

    public void setBootstrapName(String bootstrapName) {
        this.bootstrapName = bootstrapName;
    }

    public String getDeployersName() {
        return this.deployersName;
    }

    public void setDeployersName(String deployersName) {
        this.deployersName = deployersName;
    }

    public String getApplicationsName() {
        return this.applicationsName;
    }

    public void setApplicationsName(String applicationsName) {
        this.applicationsName = applicationsName;
    }

    public String getBindingsDeployment() {
        return this.bindingsDeployment;
    }

    public void setBindingsDeployment(String bindingsDeployment) {
        this.bindingsDeployment = bindingsDeployment;
    }

    public String getBootstrapDeployment() {
        return this.bootstrapDeployment;
    }

    public void setBootstrapDeployment(String bootstrapDeployment) {
        this.bootstrapDeployment = bootstrapDeployment;
    }

    public URI getConfURI() {
        return this.confURI;
    }

    public void setConfURI(URI confURI) {
        this.confURI = confURI;
    }

    public URI getDeployersURI() {
        return this.deployersURI;
    }

    public void setDeployersURI(URI deployersURI) {
        this.deployersURI = deployersURI;
    }

    public List<URI> getApplicationURIs() {
        if (this.applicationURIs == null) {
            return Collections.emptyList();
        }
        return this.applicationURIs;
    }

    public void setApplicationURIs(List<URI> applicationURIs) {
        this.applicationURIs = applicationURIs;
    }

    public ScanPeriod getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(ScanPeriod scanPeriod) {
        this.scanPeriod = scanPeriod;
    }

    public File getAttachmentStoreRoot() {
        return this.attachmentStoreRoot;
    }

    public void setAttachmentStoreRoot(File attachmentStoreRoot) {
        this.attachmentStoreRoot = attachmentStoreRoot;
    }

    protected DomainMetaDataFragment getFragment() {
        return this;
    }

    public DomainMetaData getDomainMetaData() {
        AbstractDomainMetaData domain = new AbstractDomainMetaData();
        domain.setFragments(Collections.singletonList(this.getFragment()));
        return domain;
    }

    public String getNameSpace() {
        return "";
    }

    public void visit(DomainMetaDataFragmentVisitor visitor) {
        for (ProfileMetaData profile : this.createProfiles()) {
            visitor.addProfileMetaData(profile);
        }
    }

    protected List<ProfileMetaData> createProfiles() {
        ArrayList<ProfileMetaData> profiles = new ArrayList<ProfileMetaData>();
        ArrayList<String> dependencies = new ArrayList<String>();
        profiles.add(this.createFilteredProfileMetaData(this.bindingsName, this.getConfURI(), dependencies, this.getBindingsDeployment()));
        dependencies.add(this.bindingsName);
        profiles.add(this.createFilteredProfileMetaData(this.bootstrapName, this.getConfURI(), dependencies, this.getBootstrapDeployment()));
        dependencies.add(this.bootstrapName);
        profiles.add(this.createScanningProfile(this.deployersName, this.getDeployersURI(), dependencies, false));
        dependencies.add(this.deployersName);
        this.createApplicationProfiles(profiles, dependencies);
        return profiles;
    }

    protected void createApplicationProfiles(List<ProfileMetaData> profiles, List<String> dependencies) {
        if (!this.getApplicationURIs().isEmpty()) {
            for (int i = 0; i < this.getApplicationURIs().size(); ++i) {
                URI uri = this.getApplicationURIs().get(i);
                String profileName = i == 0 ? this.applicationsName : this.applicationsName + i;
                profiles.add(this.createScanningProfile(profileName, uri, dependencies, true));
                dependencies.add(profileName);
            }
        }
    }

    protected ProfileMetaData createFilteredProfileMetaData(String name, URI root, Collection<String> dependencies, String ... deploymentNames) {
        return this.processDependencies((AbstractProfileMetaData)ProfileMetaDataFactory.createFilteredProfileMetaData((String)name, (URI)root, (String[])deploymentNames), dependencies);
    }

    protected ProfileMetaData createScanningProfile(String name, URI root, Collection<String> dependencies, boolean hotDeployment) {
        Object profile = hotDeployment ? ProfileMetaDataFactory.createHotDeploymentScanningProfile((String)name, (URI)root, (ScanPeriod)this.getScanPeriod()) : ProfileMetaDataFactory.createImmutableScanningProfile((String)name, (URI)root);
        return this.processDependencies((AbstractProfileMetaData)profile, dependencies);
    }

    protected AbstractProfileMetaData processDependencies(AbstractProfileMetaData metaData, Collection<String> names) {
        ArrayList<BasicSubProfileMetaData> nodes = new ArrayList<BasicSubProfileMetaData>();
        for (String name : names) {
            nodes.add(new BasicSubProfileMetaData(name));
        }
        metaData.setFeatures(nodes);
        return metaData;
    }
}

