/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.NioAcceptedSocketChannel;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.IoWorkerRunnable;

class NioServerSocketPipelineSink
extends AbstractChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerSocketPipelineSink.class);
    private static final AtomicInteger nextId = new AtomicInteger();
    private final int id = nextId.incrementAndGet();
    private final NioWorker[] workers;
    private final AtomicInteger workerIndex = new AtomicInteger();

    NioServerSocketPipelineSink(Executor workerExecutor, int workerCount) {
        this.workers = new NioWorker[workerCount];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new NioWorker(this.id, i + 1, workerExecutor);
        }
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof NioServerSocketChannel) {
            this.handleServerSocket(e);
        } else if (channel instanceof NioSocketChannel) {
            this.handleAcceptedSocket(e);
        }
    }

    private void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        NioServerSocketChannel channel = (NioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                this.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    this.bind(channel, future, (SocketAddress)value);
                    break;
                }
                this.close(channel, future);
            }
        }
    }

    private void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(NioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean bossStarted = false;
        try {
            channel.socket.socket().bind(localAddress, channel.getConfig().getBacklog());
            bound = true;
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
            Executor bossExecutor = ((NioServerSocketChannelFactory)channel.getFactory()).bossExecutor;
            bossExecutor.execute(new IoWorkerRunnable(new ThreadRenamingRunnable(new Boss(channel), "New I/O server boss #" + this.id + " (channelId: " + channel.getId() + ", " + channel.getLocalAddress() + ')')));
            bossStarted = true;
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
        finally {
            if (!bossStarted && bound) {
                this.close(channel, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(NioServerSocketChannel channel, ChannelFuture future) {
        boolean bound = channel.isBound();
        try {
            if (channel.socket.isOpen()) {
                channel.socket.close();
                Selector selector = channel.selector;
                if (selector != null) {
                    selector.wakeup();
                }
            }
            channel.shutdownLock.lock();
            try {
                if (channel.setClosed()) {
                    future.setSuccess();
                    if (bound) {
                        Channels.fireChannelUnbound(channel);
                    }
                    Channels.fireChannelClosed(channel);
                } else {
                    future.setSuccess();
                }
            }
            finally {
                channel.shutdownLock.unlock();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    NioWorker nextWorker() {
        return this.workers[Math.abs(this.workerIndex.getAndIncrement() % this.workers.length)];
    }

    private final class Boss
    implements Runnable {
        private final Selector selector;
        private final NioServerSocketChannel channel;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Boss(NioServerSocketChannel channel) throws IOException {
            this.channel = channel;
            this.selector = Selector.open();
            boolean registered = false;
            try {
                channel.socket.register(this.selector, 16);
                registered = true;
            }
            finally {
                if (!registered) {
                    this.closeSelector();
                }
            }
            channel.selector = this.selector;
        }

        public void run() {
            Thread currentThread = Thread.currentThread();
            this.channel.shutdownLock.lock();
            while (true) {
                try {
                    while (true) {
                        SocketChannel acceptedSocket;
                        if (this.selector.select(1000L) > 0) {
                            this.selector.selectedKeys().clear();
                        }
                        if ((acceptedSocket = this.channel.socket.accept()) == null) continue;
                        this.registerAcceptedChannel(acceptedSocket, currentThread);
                    }
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                catch (CancelledKeyException e) {
                    continue;
                }
                catch (ClosedSelectorException e) {
                    continue;
                }
                catch (ClosedChannelException e) {
                }
                catch (IOException e) {
                    logger.warn("Failed to accept a connection.", e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
            this.channel.shutdownLock.unlock();
            this.closeSelector();
        }

        private void registerAcceptedChannel(SocketChannel acceptedSocket, Thread currentThread) {
            try {
                ChannelPipeline pipeline = this.channel.getConfig().getPipelineFactory().getPipeline();
                NioWorker worker = NioServerSocketPipelineSink.this.nextWorker();
                worker.register(new NioAcceptedSocketChannel(this.channel.getFactory(), pipeline, this.channel, NioServerSocketPipelineSink.this, acceptedSocket, worker, currentThread), null);
            }
            catch (Exception e) {
                logger.warn("Failed to initialize an accepted socket.", e);
                try {
                    acceptedSocket.close();
                }
                catch (IOException e2) {
                    logger.warn("Failed to close a partially accepted socket.", e2);
                }
            }
        }

        private void closeSelector() {
            this.channel.selector = null;
            try {
                this.selector.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close a selector.", e);
            }
        }
    }
}

