/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import org.jboss.xnio.nio.NioXnio;

final class SelectorUtils {
    private SelectorUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void await(NioXnio nioXnio, SelectableChannel channel, int op) throws IOException {
        Selector selector = nioXnio.getSelector();
        try {
            SelectionKey selectionKey = channel.register(selector, op);
            selector.select();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            selectionKey.interestOps(0);
        }
        finally {
            nioXnio.returnSelector(selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void await(NioXnio nioXnio, SelectableChannel channel, int op, long time, TimeUnit unit) throws IOException {
        Selector selector = nioXnio.getSelector();
        try {
            SelectionKey selectionKey = channel.register(selector, op);
            selector.select(unit.toMillis(time));
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            selectionKey.interestOps(0);
        }
        finally {
            nioXnio.returnSelector(selector);
        }
    }
}

