/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.services;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.jboss.logging.Logger;
import org.jboss.monitor.alarm.AlarmManager;
import org.jboss.monitor.services.ScriptingListenerMBean;
import org.jboss.system.ListenerServiceMBeanSupport;
import org.jboss.system.ServiceMBeanSupport;

public class ScriptingListener
extends ListenerServiceMBeanSupport
implements ScriptingListenerMBean {
    private String script;
    private String language;
    private boolean dynamicSubscriptions;
    private ObjectName targetListener;
    private AtomicLong notificationsReceived;
    private AtomicLong notificationsProcessed;
    private AtomicLong totalProcessingTime;
    private BSFManager manager;
    private List queue;
    private boolean stopRequested;
    private Thread processorThread;
    private AlarmManager alm = new AlarmManager((ServiceMBeanSupport)this);

    public ScriptingListener() {
        this.queue = new LinkedList();
        this.notificationsReceived = new AtomicLong(0L);
        this.notificationsProcessed = new AtomicLong(0L);
        this.totalProcessingTime = new AtomicLong(0L);
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setScriptLanguage(String language) {
        this.language = language;
    }

    public String getScriptLanguage() {
        return this.language;
    }

    public void setDynamicSubscriptions(boolean dynamicSubscriptions) {
        this.dynamicSubscriptions = dynamicSubscriptions;
    }

    public boolean getDynamicSubscriptions() {
        return this.dynamicSubscriptions;
    }

    public long getNotificationsReceived() {
        return this.notificationsReceived.get();
    }

    public long getNotificationsProcessed() {
        return this.notificationsProcessed.get();
    }

    public long getTotalProcessingTime() {
        return this.totalProcessingTime.get();
    }

    public long getAverageProcessingTime() {
        long processed = this.notificationsProcessed.get();
        return processed == 0L ? 0L : this.totalProcessingTime.get() / processed;
    }

    public void startService() throws Exception {
        this.log.debug((Object)("Initializing BSFManager for language '" + this.language + "'"));
        BSFManager.registerScriptingEngine((String)"groovy", (String)"org.codehaus.groovy.bsf.GroovyEngine", (String[])new String[]{"groovy", "gy"});
        this.manager = new BSFManager();
        this.manager.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.manager.loadScriptingEngine(this.language);
        this.manager.declareBean("log", (Object)this.log, Logger.class);
        this.manager.declareBean("server", (Object)this.server, MBeanServer.class);
        this.manager.declareBean("manager", (Object)this.alm, AlarmManager.class);
        Notification testNotification = new Notification("jboss.script.test", this.serviceName, 0L);
        this.manager.declareBean("notification", (Object)testNotification, Notification.class);
        this.manager.declareBean("handback", (Object)"", Object.class);
        this.manager.exec(this.language, "in-memory-script", 0, 0, (Object)this.script);
        this.processorThread = new Thread((Runnable)new ScriptProcessor(), "ScriptProcessor[" + this.serviceName + "]");
        this.processorThread.start();
        super.subscribe(this.dynamicSubscriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        super.unsubscribe();
        this.log.debug((Object)("Stopping " + this.processorThread.getName()));
        this.stopRequested = true;
        List list = this.queue;
        synchronized (list) {
            this.queue.notify();
        }
        try {
            this.processorThread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.queue.clear();
        this.manager.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification2(Notification notification, Object handback) {
        this.notificationsReceived.incrementAndGet();
        List list = this.queue;
        synchronized (list) {
            this.queue.add(new QueueEntry(notification, handback));
            this.queue.notify();
        }
    }

    private class ScriptProcessor
    implements Runnable {
        private ScriptProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String name = Thread.currentThread().getName();
            ScriptingListener.this.log.debug((Object)("Started thread: " + name));
            boolean intr = false;
            try {
                while (!ScriptingListener.this.stopRequested) {
                    QueueEntry entry;
                    List list = ScriptingListener.this.queue;
                    synchronized (list) {
                        while (ScriptingListener.this.queue.isEmpty() && !ScriptingListener.this.stopRequested) {
                            try {
                                ScriptingListener.this.queue.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (ScriptingListener.this.stopRequested) {
                            break;
                        }
                        entry = (QueueEntry)ScriptingListener.this.queue.remove(0);
                    }
                    long start = System.currentTimeMillis();
                    try {
                        ScriptingListener.this.manager.declareBean("notification", (Object)entry.notification, Notification.class);
                        ScriptingListener.this.manager.declareBean("handback", entry.handback == null ? "" : entry.handback, Object.class);
                        ScriptingListener.this.manager.exec(ScriptingListener.this.language, "in-memory-script", 0, 0, (Object)ScriptingListener.this.script);
                    }
                    catch (BSFException e) {
                        ScriptingListener.this.log.warn((Object)"Caught exception", (Throwable)e);
                    }
                    long stop = System.currentTimeMillis();
                    ScriptingListener.this.totalProcessingTime.addAndGet(stop - start);
                    ScriptingListener.this.notificationsProcessed.incrementAndGet();
                }
                ScriptingListener.this.log.debug((Object)("Stopped thread: " + name));
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class QueueEntry {
        public Notification notification;
        public Object handback;

        public QueueEntry(Notification notification, Object handback) {
            this.notification = notification;
            this.handback = handback;
        }
    }
}

