/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.DoubleAttribute;
import org.jboss.security.xacml.sunxacml.attr.IntegerAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.FunctionBase;

public class DivideFunction
extends FunctionBase {
    public static final String NAME_INTEGER_DIVIDE = "urn:oasis:names:tc:xacml:1.0:function:integer-divide";
    public static final String NAME_DOUBLE_DIVIDE = "urn:oasis:names:tc:xacml:1.0:function:double-divide";
    private static final int ID_INTEGER_DIVIDE = 0;
    private static final int ID_DOUBLE_DIVIDE = 1;

    public DivideFunction(String functionName) {
        super(functionName, DivideFunction.getId(functionName), DivideFunction.getArgumentType(functionName), false, 2, DivideFunction.getArgumentType(functionName), false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_INTEGER_DIVIDE)) {
            return 0;
        }
        if (functionName.equals(NAME_DOUBLE_DIVIDE)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown divide function " + functionName);
    }

    private static String getArgumentType(String functionName) {
        if (functionName.equals(NAME_INTEGER_DIVIDE)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#double";
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_INTEGER_DIVIDE);
        set.add(NAME_DOUBLE_DIVIDE);
        return set;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        switch (this.getFunctionId()) {
            case 0: {
                long dividend = ((IntegerAttribute)argValues[0]).getValue();
                long divisor = ((IntegerAttribute)argValues[1]).getValue();
                if (divisor == 0L) {
                    result = DivideFunction.makeProcessingError("divide by zero");
                    break;
                }
                long quotient = dividend / divisor;
                result = new EvaluationResult(new IntegerAttribute(quotient));
                break;
            }
            case 1: {
                double dividend = ((DoubleAttribute)argValues[0]).getValue();
                double divisor = ((DoubleAttribute)argValues[1]).getValue();
                if (divisor == 0.0) {
                    result = DivideFunction.makeProcessingError("divide by zero");
                    break;
                }
                double quotient = dividend / divisor;
                result = new EvaluationResult(new DoubleAttribute(quotient));
                break;
            }
        }
        return result;
    }
}

