/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.weld;

import java.net.URL;
import java.util.Collection;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.scanning.plugins.helpers.VoidScanningHandle;
import org.jboss.scanning.spi.helpers.AbstractScanningPlugin;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldScanningPlugin
extends AbstractScanningPlugin<VoidScanningHandle, Object> {
    private ResourceVisitor visitor;
    private Collection<VirtualFile> cpFiles;

    public WeldScanningPlugin(WeldDiscoveryEnvironment environment, Collection<VirtualFile> cpFiles) {
        this.visitor = new WBDiscoveryVisitor(environment);
        this.cpFiles = cpFiles;
    }

    protected VoidScanningHandle doCreateHandle() {
        return VoidScanningHandle.INSTANCE;
    }

    public Class<Object> getHandleInterface() {
        return Object.class;
    }

    public void cleanupHandle(Object handle) {
        this.visitor = null;
    }

    public ResourceFilter getRecurseFilter() {
        return new ResourceFilter(){

            public boolean accepts(ResourceContext resource) {
                try {
                    VirtualFile[] parents;
                    URL url = resource.getUrl();
                    VirtualFile file = VFS.getChild((URL)url);
                    for (VirtualFile parent : parents = file.getParentFiles()) {
                        if (!WeldScanningPlugin.this.cpFiles.contains(parent)) continue;
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public ResourceFilter getFilter() {
        return this.visitor.getFilter();
    }

    public void visit(ResourceContext resource) {
        this.visitor.visit(resource);
    }

    private static class WBDiscoveryVisitor
    implements ResourceVisitor {
        private Collection<Class<?>> classes;

        private WBDiscoveryVisitor(WeldDiscoveryEnvironment wbdi) {
            this.classes = wbdi.getWeldClasses();
        }

        public ResourceFilter getFilter() {
            return ClassFilter.INSTANCE;
        }

        public void visit(ResourceContext resource) {
            this.classes.add(resource.loadClass());
        }
    }
}

