/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.annotations.plugins;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;

public class SignatureSerializer
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private transient Signature signature;

    public SignatureSerializer() {
    }

    public SignatureSerializer(Signature signature) {
        this.signature = signature;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        MethodSignature methodSignature;
        ConstructorSignature constructorSignature;
        String declaringClass = null;
        String name = null;
        String[] parameters = null;
        Integer parameterIndex = -1;
        if (this.signature instanceof ConstructorSignature) {
            constructorSignature = (ConstructorSignature)this.signature;
            parameters = constructorSignature.getParameters();
        } else if (this.signature instanceof MethodSignature) {
            methodSignature = (MethodSignature)this.signature;
            name = methodSignature.getName();
            parameters = methodSignature.getParameters();
        } else if (this.signature instanceof DeclaredMethodSignature) {
            methodSignature = (DeclaredMethodSignature)this.signature;
            declaringClass = methodSignature.getDeclaringClass();
            name = methodSignature.getName();
            parameters = methodSignature.getParameters();
        } else if (this.signature instanceof MethodParametersSignature) {
            methodSignature = (MethodParametersSignature)this.signature;
            name = methodSignature.getName();
            parameters = methodSignature.getParameters();
            parameterIndex = methodSignature.getParam();
        } else if (this.signature instanceof ConstructorParametersSignature) {
            constructorSignature = (ConstructorParametersSignature)this.signature;
            parameters = constructorSignature.getParameters();
            parameterIndex = constructorSignature.getParam();
        } else if (this.signature instanceof FieldSignature) {
            FieldSignature fieldSignature = (FieldSignature)this.signature;
            name = fieldSignature.getName();
        } else {
            throw new IllegalArgumentException("Unknown signature type: " + this.signature);
        }
        boolean bdc = declaringClass != null;
        out.writeBoolean(bdc);
        if (bdc) {
            out.writeUTF(declaringClass);
        }
        out.writeUTF(name);
        boolean bp = parameters != null;
        out.writeBoolean(bp);
        if (bp) {
            out.writeObject(parameters);
        }
        out.writeObject(parameterIndex);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String declaringClass = null;
        if (in.readBoolean()) {
            declaringClass = in.readUTF();
        }
        String name = in.readUTF();
        String[] parameters = null;
        if (in.readBoolean()) {
            parameters = (String[])in.readObject();
        }
        Integer parameterIndex = (Integer)in.readObject();
        this.signature = name == null ? (parameterIndex >= 0 ? new ConstructorParametersSignature(parameterIndex.intValue(), parameters) : new ConstructorSignature(parameters)) : (declaringClass != null ? new DeclaredMethodSignature(declaringClass, name, parameters) : (parameters == null ? new FieldSignature(name) : (parameterIndex >= 0 ? new MethodParametersSignature(name, parameters, parameterIndex.intValue()) : new MethodSignature(name, parameters))));
    }
}

