/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.ispn;

import java.security.AccessController;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.util.loading.ContextClassLoaderSwitcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class DefaultCacheContainer
implements EmbeddedCacheManager {
    private final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    private final EmbeddedCacheManager container;
    private final ConcurrentMap<String, EmbeddedCacheManager> containers = new ConcurrentHashMap<String, EmbeddedCacheManager>();

    public DefaultCacheContainer(EmbeddedCacheManager manager) {
        this.container = manager;
    }

    public <K, V> Cache<K, V> getCache() {
        return this.getCache("___defaultcache");
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, cacheName.equals("___defaultcache") ? this.container.getDefaultConfiguration() : this.container.defineConfiguration(cacheName, new Configuration()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Cache<K, V> getCache(String cacheName, Configuration config) {
        ContextClassLoaderSwitcher.SwitchContext context = this.switcher.getSwitchContext(this.getClass().getClassLoader());
        try {
            if (config.getCacheMode().isDistributed()) {
                GlobalConfiguration globalConfig = this.container.getGlobalConfiguration();
                String containerName = this.appendCacheName(globalConfig.getCacheManagerName(), cacheName);
                Object container = (EmbeddedCacheManager)this.containers.get(containerName);
                if (container == null) {
                    GlobalConfiguration global = globalConfig.clone();
                    global.setCacheManagerName(containerName);
                    global.setClusterName(this.appendCacheName(globalConfig.getClusterName(), cacheName));
                    global.getTransportProperties().setProperty("channelId", global.getClusterName());
                    container = new SingletonCacheManager(this, cacheName, global, config);
                    EmbeddedCacheManager existing = this.containers.putIfAbsent(containerName, (EmbeddedCacheManager)container);
                    if (existing == null) {
                        container.addListener((Object)this);
                        for (Object listener : this.container.getListeners()) {
                            container.addListener(listener);
                        }
                        container.start();
                    } else {
                        container = existing;
                    }
                }
                Cache cache = container.getCache(cacheName);
                return cache;
            }
            Cache cache = this.container.getCache(cacheName);
            return cache;
        }
        finally {
            context.reset();
        }
    }

    private String appendCacheName(String name, String cacheName) {
        return name + "/" + cacheName;
    }

    public synchronized void start() {
        this.container.start();
    }

    public synchronized void stop() {
        this.container.stop();
    }

    public void addListener(Object listener) {
        this.container.addListener(listener);
    }

    public void removeListener(Object listener) {
        this.container.removeListener(listener);
    }

    public Set<Object> getListeners() {
        return this.container.getListeners();
    }

    public Configuration defineConfiguration(String cacheName, Configuration configurationOverride) {
        return this.container.defineConfiguration(cacheName, configurationOverride);
    }

    public Configuration defineConfiguration(String cacheName, String templateCacheName, Configuration configurationOverride) {
        return this.container.defineConfiguration(cacheName, templateCacheName, configurationOverride);
    }

    public String getClusterName() {
        return this.container.getClusterName();
    }

    public List<Address> getMembers() {
        return this.container.getMembers();
    }

    public Address getAddress() {
        return this.container.getAddress();
    }

    public boolean isCoordinator() {
        return this.container.isCoordinator();
    }

    public ComponentStatus getStatus() {
        return this.container.getStatus();
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.container.getGlobalConfiguration();
    }

    public Configuration getDefaultConfiguration() {
        return this.container.getDefaultConfiguration();
    }

    public Set<String> getCacheNames() {
        return this.container.getCacheNames();
    }

    public Address getCoordinator() {
        return this.container.getCoordinator();
    }

    public boolean isDefaultRunning() {
        return this.container.isDefaultRunning();
    }

    public boolean isRunning(String cacheName) {
        EmbeddedCacheManager container = (EmbeddedCacheManager)this.containers.get(this.appendCacheName(this.container.getGlobalConfiguration().getCacheManagerName(), cacheName));
        return container != null ? container.isDefaultRunning() : this.container.isRunning(cacheName);
    }

    @CacheStopped
    public synchronized void cacheStopped(CacheStoppedEvent event) {
        EmbeddedCacheManager container = event.getCacheManager();
        this.containers.remove(container.getGlobalConfiguration().getCacheManagerName());
        container.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingletonCacheManager
    extends DefaultCacheManager {
        private final EmbeddedCacheManager parent;
        private final String cacheName;

        SingletonCacheManager(EmbeddedCacheManager parent, String cacheName, GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
            super(globalConfiguration, defaultConfiguration, false);
            this.parent = parent;
            this.cacheName = cacheName;
        }

        public <K, V> Cache<K, V> getCache(String name) {
            return this.cacheName.equals(name) ? super.getCache("___defaultcache") : this.parent.getCache(name);
        }

        public boolean isRunning(String cacheName) {
            return this.cacheName.equals(cacheName) ? super.isRunning("___defaultcache") : this.parent.isRunning(cacheName);
        }

        public void addListener(Object listener) {
            super.addListener(listener);
            if (listener != this.parent) {
                super.removeListener((Object)this.parent);
                super.addListener((Object)this.parent);
            }
        }
    }
}

