/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;

public class BaseRequest {
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    MessageBytes method = MessageBytes.newInstance();
    MessageBytes protocol = MessageBytes.newInstance();
    MessageBytes requestURI = MessageBytes.newInstance();
    MessageBytes remoteAddr = MessageBytes.newInstance();
    MessageBytes remoteHost = MessageBytes.newInstance();
    MessageBytes serverName = MessageBytes.newInstance();
    int serverPort = 80;
    MessageBytes remoteUser = MessageBytes.newInstance();
    MessageBytes authType = MessageBytes.newInstance();
    MessageBytes queryString = MessageBytes.newInstance();
    MessageBytes authorization = MessageBytes.newInstance();
    String scheme = "http";
    boolean secure = false;
    int contentLength = 0;
    MessageBytes contentType = MessageBytes.newInstance();
    MimeHeaders headers = new MimeHeaders();
    Cookies cookies = new Cookies(this.headers);
    HashMap attributes = new HashMap();
    MessageBytes tomcatInstanceId = MessageBytes.newInstance();
    private Object[] notes = new Object[16];

    public void recycle() {
        this.method.recycle();
        this.protocol.recycle();
        this.requestURI.recycle();
        this.remoteAddr.recycle();
        this.remoteHost.recycle();
        this.serverName.recycle();
        this.serverPort = 80;
        this.remoteUser.recycle();
        this.authType.recycle();
        this.queryString.recycle();
        this.authorization.recycle();
        this.scheme = SCHEME_HTTP;
        this.secure = false;
        this.contentLength = 0;
        this.contentType.recycle();
        this.headers.recycle();
        this.cookies.recycle();
        this.attributes.clear();
        this.tomcatInstanceId.recycle();
    }

    public MessageBytes method() {
        return this.method;
    }

    public MessageBytes protocol() {
        return this.protocol;
    }

    public MessageBytes requestURI() {
        return this.requestURI;
    }

    public MessageBytes remoteAddr() {
        return this.remoteAddr;
    }

    public MessageBytes remoteHost() {
        return this.remoteHost;
    }

    public MessageBytes serverName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int i) {
        this.serverPort = i;
    }

    public MessageBytes remoteUser() {
        return this.remoteUser;
    }

    public MessageBytes authType() {
        return this.authType;
    }

    public MessageBytes queryString() {
        return this.queryString;
    }

    public MessageBytes authorization() {
        return this.authorization;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String s) {
        this.scheme = s;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int i) {
        this.contentLength = i;
    }

    public MessageBytes contentType() {
        return this.contentType;
    }

    public MimeHeaders headers() {
        return this.headers;
    }

    public Cookies cookies() {
        return this.cookies;
    }

    public void setAttribute(String name, Object value) {
        if (name == null || value == null) {
            return;
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public MessageBytes instanceId() {
        return this.tomcatInstanceId;
    }

    public MessageBytes jvmRoute() {
        return this.tomcatInstanceId;
    }

    public final Object getNote(int id) {
        return this.notes[id];
    }

    public final void setNote(int id, Object cr) {
        this.notes[id] = cr;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== BaseRequest ===");
        pw.println("method          = " + this.method.toString());
        pw.println("protocol        = " + this.protocol.toString());
        pw.println("requestURI      = " + this.requestURI.toString());
        pw.println("remoteAddr      = " + this.remoteAddr.toString());
        pw.println("remoteHost      = " + this.remoteHost.toString());
        pw.println("serverName      = " + this.serverName.toString());
        pw.println("serverPort      = " + this.serverPort);
        pw.println("remoteUser      = " + this.remoteUser.toString());
        pw.println("authType        = " + this.authType.toString());
        pw.println("queryString     = " + this.queryString.toString());
        pw.println("scheme          = " + this.scheme.toString());
        pw.println("secure          = " + this.secure);
        pw.println("contentLength   = " + this.contentLength);
        pw.println("contentType     = " + this.contentType);
        pw.println("attributes      = " + this.attributes.toString());
        pw.println("headers         = " + this.headers.toString());
        pw.println("cookies         = " + this.cookies.toString());
        pw.println("jvmRoute        = " + this.tomcatInstanceId.toString());
        return sw.toString();
    }
}

