/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.jboss.aspects.versioned.DistributedState;
import org.jboss.aspects.versioned.DistributedUpdate;
import org.jboss.aspects.versioned.DistributedVersionManager;
import org.jboss.aspects.versioned.LocalSynchronizationManager;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedSynchronizationManager
extends LocalSynchronizationManager
implements HAPartition.HAMembershipListener {
    private static final Object[] NULL_ARGS = new Object[0];
    private static final Class[] NULL_TYPES = new Class[0];
    protected static final Class[] STRING_TYPE = new Class[]{String.class};
    protected static final Class[] LIST_TYPE = new Class[]{List.class};
    protected static final Class[] LOCK_TYPES = new Class[]{String.class, GUID.class, List.class};
    protected static Logger log = Logger.getLogger(DistributedSynchronizationManager.class);
    protected HAPartition partition;
    protected String domainName;
    protected Hashtable heldLocks = new Hashtable();

    public DistributedSynchronizationManager(String domainName, DistributedVersionManager versionManager, HAPartition partition) {
        super(versionManager);
        this.partition = partition;
        this.domainName = domainName + "/SynchManager";
    }

    public void create() throws Exception {
        this.partition.registerRPCHandler(this.domainName, (Object)this);
    }

    public void start() throws Exception {
        this.pullState();
    }

    protected void pullState() throws Exception {
        List rsp = this.partition.callMethodOnCluster(this.domainName, "getCurrentState", NULL_ARGS, NULL_TYPES, Serializable.class, true, null, this.partition.getMethodCallTimeout(), false);
        if (rsp.size() > 0) {
            this.setCurrentState((Serializable)rsp.get(0));
        }
    }

    public Serializable getCurrentState() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"getCurrentState called");
        }
        return this.stateTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentState(Serializable newState) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"setCurrentState called");
        }
        try {
            Object object = this.tableLock;
            synchronized (object) {
                this.stateTable = (Hashtable)newState;
                log.trace((Object)("setCurrentState, size: " + this.stateTable.size()));
                for (DistributedState state : this.stateTable.values()) {
                    if (this.objectTable.containsKey(state.getGUID())) continue;
                    state.buildObject(this, this.versionManager);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"failed to set state sent from cluster", (Throwable)ex);
        }
    }

    public void membershipChanged(Vector<ClusterNode> deadMembers, Vector<ClusterNode> newMembers, Vector<ClusterNode> allMembers) {
        for (int i = 0; i < deadMembers.size(); ++i) {
            Hashtable held = (Hashtable)this.heldLocks.remove(deadMembers.get(i));
            if (held == null) continue;
            for (List list : held.values()) {
                this.releaseHeldLocks(list);
            }
        }
    }

    @Override
    public void sendNewObjects(List newObjects) throws Exception {
        log.trace((Object)"sending new objects");
        try {
            Object[] args = new Object[]{newObjects};
            this.checkResponses(this.partition.callMethodOnCluster(this.domainName, "addNewObjects", args, LIST_TYPE, true));
        }
        catch (Exception ex) {
            log.error((Object)"serious cache problems, data inconsistency is imminent", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    protected void sendClusterUpdatesAndRelease(GUID globalTxId, List clusterUpdates) throws Exception {
        try {
            Object[] args = new Object[]{this.partition.getNodeName(), globalTxId, clusterUpdates};
            this.checkResponses(this.partition.callMethodOnCluster(this.domainName, "updateObjects", args, LOCK_TYPES, true));
        }
        catch (Exception ex) {
            log.error((Object)"serious cache problems, data inconsistency is imminent", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    protected void acquireRemoteLocks(GUID globalTxId, List guids) throws Exception {
        try {
            Object[] args = new Object[]{this.partition.getNodeName(), globalTxId, guids};
            this.checkResponses(this.partition.callMethodOnCluster(this.domainName, "acquireLocks", args, LOCK_TYPES, true));
        }
        catch (Exception ex) {
            try {
                Object[] args = new Object[]{this.partition.getNodeName()};
                this.partition.callMethodOnCluster(this.domainName, "releaseHeldLocks", args, STRING_TYPE, true);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw ex;
        }
    }

    @Override
    public void noTxUpdate(DistributedUpdate update) throws Exception {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewObjects(List newObjects) throws Exception {
        Object object = this.tableLock;
        synchronized (object) {
            DistributedState state;
            int i;
            for (i = 0; i < newObjects.size(); ++i) {
                state = (DistributedState)newObjects.get(i);
                this.stateTable.put(state.getGUID(), state);
            }
            for (i = 0; i < newObjects.size(); ++i) {
                state = (DistributedState)newObjects.get(i);
                if (this.objectTable.containsKey(state.getGUID())) continue;
                state.buildObject(this, this.versionManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjects(String nodeName, GUID globalTxId, ArrayList updates) throws Exception {
        log.trace((Object)"updateObjects");
        Object object = this.tableLock;
        synchronized (object) {
            for (int i = 0; i < updates.size(); ++i) {
                DistributedUpdate update = (DistributedUpdate)updates.get(i);
                DistributedState state = (DistributedState)this.stateTable.get(update.getGUID());
                state.mergeState(update);
                state.releaseWriteLock();
            }
        }
        Hashtable table = (Hashtable)this.heldLocks.get(nodeName);
        table.remove(globalTxId);
        log.trace((Object)"end updateObjects");
    }

    public void releaseHeldLocks(String nodeName, GUID globalTxId) {
        Hashtable held = (Hashtable)this.heldLocks.get(nodeName);
        if (held == null) {
            return;
        }
        List locks = (List)held.remove(globalTxId);
        if (locks != null) {
            this.releaseHeldLocks(locks);
        }
    }

    public void acquireLocks(String nodeName, GUID globalTxId, List list) throws Exception {
        log.trace((Object)"acquireLocks");
        ArrayList<DistributedState> locks = new ArrayList<DistributedState>();
        try {
            for (int i = 0; i < list.size(); ++i) {
                GUID guid = (GUID)list.get(i);
                DistributedState state = this.getState(guid);
                state.acquireWriteLock();
                locks.add(state);
            }
            Hashtable held = (Hashtable)this.heldLocks.get(nodeName);
            if (held == null) {
                held = new Hashtable();
                this.heldLocks.put(nodeName, held);
            }
            held.put(globalTxId, locks);
        }
        catch (Exception ex) {
            this.releaseHeldLocks(locks);
            throw ex;
        }
        log.trace((Object)"end acquireLocks");
    }

    protected void checkResponses(List rsps) throws Exception {
        if (rsps != null) {
            for (Object rsp : rsps) {
                if (rsp == null) continue;
                if (rsp instanceof RuntimeException) {
                    throw (RuntimeException)rsp;
                }
                if (!(rsp instanceof Exception)) continue;
                throw (Exception)rsp;
            }
        }
    }
}

