/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class ReusableLatch {
    private final CountSync control;

    public ReusableLatch() {
        this(0);
    }

    public ReusableLatch(int count) {
        this.control = new CountSync(count);
    }

    public int getCount() {
        return this.control.getCount();
    }

    public void setCount(int count) {
        this.control.setCount(count);
    }

    public void countUp() {
        this.control.add();
    }

    public void countDown() {
        this.control.releaseShared(1);
    }

    public void await() throws InterruptedException {
        this.control.acquireSharedInterruptibly(1);
    }

    public boolean await(long milliseconds) throws InterruptedException {
        return this.control.tryAcquireSharedNanos(1, TimeUnit.MILLISECONDS.toNanos(milliseconds));
    }

    public boolean await(long timeWait, TimeUnit timeUnit) throws InterruptedException {
        return this.control.tryAcquireSharedNanos(1, timeUnit.toNanos(timeWait));
    }

    private static class CountSync
    extends AbstractQueuedSynchronizer {
        public CountSync(int count) {
            this.setState(count);
        }

        public int getCount() {
            return this.getState();
        }

        public void setCount(int count) {
            this.setState(count);
        }

        @Override
        public int tryAcquireShared(int numberOfAqcquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        public void add() {
            int newState;
            int actualState;
            while (!this.compareAndSetState(actualState = this.getState(), newState = actualState + 1)) {
            }
        }

        @Override
        public boolean tryReleaseShared(int numberOfReleases) {
            int newState;
            int actualState;
            do {
                if ((actualState = this.getState()) != 0) continue;
                return true;
            } while (!this.compareAndSetState(actualState, newState = actualState - numberOfReleases));
            return newState == 0;
        }
    }
}

