/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.MessageFlowRecord;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.utils.Future;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public class BridgeImpl
implements Bridge,
SessionFailureListener,
SendAcknowledgementHandler {
    private static final Logger log = Logger.getLogger(BridgeImpl.class);
    private final UUID nodeUUID;
    private final SimpleString name;
    private Queue queue;
    private final Executor executor;
    private final Filter filter;
    private final SimpleString forwardingAddress;
    private final java.util.Queue<MessageReference> refs = new ConcurrentLinkedQueue<MessageReference>();
    private final Transformer transformer;
    private volatile ClientSessionFactory csf;
    private volatile ClientSessionInternal session;
    private volatile ClientProducer producer;
    private volatile boolean started;
    private final boolean useDuplicateDetection;
    private volatile boolean active;
    private final Pair<TransportConfiguration, TransportConfiguration> connectorPair;
    private final String discoveryAddress;
    private final int discoveryPort;
    private final long retryInterval;
    private final double retryIntervalMultiplier;
    private final int reconnectAttempts;
    private final boolean failoverOnServerShutdown;
    private final int confirmationWindowSize;
    private final SimpleString idsHeaderName;
    private final MessageFlowRecord flowRecord;
    private final SimpleString managementAddress;
    private final SimpleString managementNotificationAddress;
    private final String user;
    private final String password;
    private boolean activated;
    private NotificationService notificationService;
    private ClientConsumer notifConsumer;

    public BridgeImpl(UUID nodeUUID, SimpleString name, Queue queue, String discoveryAddress, int discoveryPort, Pair<TransportConfiguration, TransportConfiguration> connectorPair, Executor executor, SimpleString filterString, SimpleString forwardingAddress, ScheduledExecutorService scheduledExecutor, Transformer transformer, long retryInterval, double retryIntervalMultiplier, int reconnectAttempts, boolean failoverOnServerShutdown, boolean useDuplicateDetection, int confirmationWindowSize, SimpleString managementAddress, SimpleString managementNotificationAddress, String user, String password, MessageFlowRecord flowRecord, boolean activated, StorageManager storageManager) throws Exception {
        this.nodeUUID = nodeUUID;
        this.name = name;
        this.queue = queue;
        this.executor = executor;
        this.filter = FilterImpl.createFilter(filterString);
        this.forwardingAddress = forwardingAddress;
        this.transformer = transformer;
        this.useDuplicateDetection = useDuplicateDetection;
        if (confirmationWindowSize <= 0) {
            throw new IllegalStateException("confirmation-window-size must be > 0 for a bridge");
        }
        this.confirmationWindowSize = confirmationWindowSize;
        this.discoveryAddress = discoveryAddress;
        this.discoveryPort = discoveryPort;
        this.connectorPair = connectorPair;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.reconnectAttempts = reconnectAttempts;
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.idsHeaderName = MessageImpl.HDR_ROUTE_TO_IDS.concat(name);
        this.managementAddress = managementAddress;
        this.managementNotificationAddress = managementNotificationAddress;
        this.user = user;
        this.password = password;
        this.flowRecord = flowRecord;
        this.activated = activated;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.activated) {
            this.executor.execute(new CreateObjectsRunnable());
        }
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), NotificationType.BRIDGE_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    private void cancelRefs() throws Exception {
        MessageReference ref;
        LinkedList<MessageReference> list = new LinkedList<MessageReference>();
        while ((ref = this.refs.poll()) != null) {
            list.addFirst(ref);
        }
        Queue queue = null;
        for (MessageReference ref2 : list) {
            queue = ref2.getQueue();
            queue.cancel(ref2);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started && this.csf != null) {
            this.csf.close();
        }
        this.executor.execute(new StopRunnable());
        this.waitForRunnablesToComplete();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), NotificationType.BRIDGE_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                log.warn("unable to send notification when broadcast group is stopped", e);
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void activate() {
        this.activated = true;
        this.executor.execute(new CreateObjectsRunnable());
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SimpleString getForwardingAddress() {
        return this.forwardingAddress;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public boolean isUseDuplicateDetection() {
        return this.useDuplicateDetection;
    }

    @Override
    public RemotingConnection getForwardingConnection() {
        if (this.session == null) {
            return null;
        }
        return this.session.getConnection();
    }

    @Override
    public void sendAcknowledged(Message message) {
        try {
            MessageReference ref = this.refs.poll();
            if (ref != null) {
                ref.getQueue().acknowledge(ref);
            }
        }
        catch (Exception e) {
            log.error("Failed to ack", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        if (this.filter != null && !this.filter.match(ref.getMessage())) {
            return HandleStatus.NO_MATCH;
        }
        BridgeImpl bridgeImpl = this;
        synchronized (bridgeImpl) {
            if (!this.active) {
                return HandleStatus.BUSY;
            }
            ref.handled();
            ServerMessage message = ref.getMessage();
            this.refs.add(ref);
            if (this.flowRecord != null) {
                message = message.copy();
                HashSet<SimpleString> propNames = new HashSet<SimpleString>(message.getPropertyNames());
                byte[] queueIds = message.getBytesProperty(this.idsHeaderName);
                for (SimpleString propName : propNames) {
                    if (!propName.startsWith(MessageImpl.HDR_ROUTE_TO_IDS)) continue;
                    message.removeProperty(propName);
                }
                message.putBytesProperty(MessageImpl.HDR_ROUTE_TO_IDS, queueIds);
            }
            if (this.useDuplicateDetection && !message.containsProperty(Message.HDR_DUPLICATE_DETECTION_ID)) {
                byte[] bytes = new byte[24];
                ByteBuffer bb = ByteBuffer.wrap(bytes);
                bb.put(this.nodeUUID.asBytes());
                bb.putLong(message.getMessageID());
                message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, bytes);
            }
            if (this.transformer != null) {
                message = this.transformer.transform(message);
            }
            SimpleString dest = this.forwardingAddress != null ? this.forwardingAddress : message.getAddress();
            this.producer.send(dest, (Message)message);
            return HandleStatus.HANDLED;
        }
    }

    @Override
    public void connectionFailed(HornetQException me) {
        this.fail(false);
    }

    @Override
    public void beforeReconnect(HornetQException exception) {
        this.fail(true);
    }

    private void waitForRunnablesToComplete() {
        Future future = new Future();
        this.executor.execute(future);
        boolean ok = future.await(10000L);
        if (!ok) {
            log.warn("Timed out waiting to stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(boolean beforeReconnect) {
        block8: {
            if (this.session.getConnection().isDestroyed()) {
                this.active = false;
            }
            try {
                if (this.session.getConnection().isDestroyed()) break block8;
                if (beforeReconnect) {
                    BridgeImpl bridgeImpl = this;
                    synchronized (bridgeImpl) {
                        this.active = false;
                    }
                    this.cancelRefs();
                    break block8;
                }
                this.setupNotificationConsumer();
                this.active = true;
                if (this.queue != null) {
                    this.queue.deliverAsync();
                }
            }
            catch (Exception e) {
                log.error("Failed to cancel refs", e);
            }
        }
    }

    private void setupNotificationConsumer() throws Exception {
        if (this.flowRecord != null) {
            this.flowRecord.reset();
            if (this.notifConsumer != null) {
                try {
                    this.notifConsumer.close();
                    this.notifConsumer = null;
                }
                catch (HornetQException e) {
                    log.error("Failed to close consumer", e);
                }
            }
            String qName = "notif." + UUIDGenerator.getInstance().generateStringUUID();
            SimpleString notifQueueName = new SimpleString(qName);
            SimpleString filter = new SimpleString(ManagementHelper.HDR_BINDING_TYPE + "<>" + BindingType.DIVERT.toInt() + " AND " + ManagementHelper.HDR_NOTIFICATION_TYPE + " IN ('" + (Object)((Object)NotificationType.BINDING_ADDED) + "','" + (Object)((Object)NotificationType.BINDING_REMOVED) + "','" + (Object)((Object)NotificationType.CONSUMER_CREATED) + "','" + (Object)((Object)NotificationType.CONSUMER_CLOSED) + "','" + (Object)((Object)NotificationType.PROPOSAL) + "','" + (Object)((Object)NotificationType.PROPOSAL_RESPONSE) + "') AND " + ManagementHelper.HDR_DISTANCE + "<" + this.flowRecord.getMaxHops() + " AND (" + ManagementHelper.HDR_ADDRESS + " LIKE '" + this.flowRecord.getAddress() + "%')");
            this.session.createQueue(this.managementNotificationAddress, notifQueueName, filter, false);
            this.notifConsumer = this.session.createConsumer(notifQueueName);
            this.notifConsumer.setMessageHandler(this.flowRecord);
            this.session.start();
            ClientMessage message = this.session.createMessage(false);
            ManagementHelper.putOperationInvocation(message, "core.server", "sendQueueInfoToQueue", notifQueueName.toString(), this.flowRecord.getAddress());
            ClientProducer prod = this.session.createProducer(this.managementAddress);
            prod.send(message);
        }
    }

    private synchronized boolean createObjects() {
        if (!this.started) {
            return false;
        }
        boolean retry = false;
        do {
            log.info("Connecting bridge " + this.name + " to its destination");
            try {
                this.csf = this.discoveryAddress != null ? HornetQClient.createClientSessionFactory(this.discoveryAddress, this.discoveryPort) : HornetQClient.createClientSessionFactory((TransportConfiguration)this.connectorPair.a, (TransportConfiguration)this.connectorPair.b);
                this.csf.setFailoverOnServerShutdown(this.failoverOnServerShutdown);
                this.csf.setRetryInterval(this.retryInterval);
                this.csf.setRetryIntervalMultiplier(this.retryIntervalMultiplier);
                this.csf.setReconnectAttempts(this.reconnectAttempts);
                this.csf.setBlockOnDurableSend(false);
                this.csf.setConfirmationWindowSize(this.confirmationWindowSize);
                this.session = (ClientSessionInternal)this.csf.createSession(this.user, this.password, false, true, true, true, 1);
                if (this.session == null) {
                    return false;
                }
                this.producer = this.session.createProducer();
                this.session.addFailureListener(this);
                this.session.setSendAcknowledgementHandler(this);
                this.setupNotificationConsumer();
                this.active = true;
                this.queue.addConsumer(this);
                this.queue.deliverAsync();
                log.info("Bridge " + this.name + " is connected to its destination");
                return true;
            }
            catch (HornetQException e) {
                this.csf.close();
                if (e.getCode() == 112) {
                    log.warn("Server is starting, retry to create the session for bridge " + this.name);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    retry = true;
                    continue;
                }
                log.warn("Bridge " + this.name + " is unable to connect to destination. It will be disabled.", e);
                return false;
            }
            catch (Exception e) {
                log.warn("Bridge " + this.name + " is unable to connect to destination. It will be disabled.", e);
                return false;
            }
        } while (retry);
        return false;
    }

    private class CreateObjectsRunnable
    implements Runnable {
        private CreateObjectsRunnable() {
        }

        @Override
        public synchronized void run() {
            if (!BridgeImpl.this.createObjects()) {
                BridgeImpl.this.active = false;
                BridgeImpl.this.started = false;
            }
        }
    }

    private class StopRunnable
    implements Runnable {
        private StopRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BridgeImpl bridgeImpl = BridgeImpl.this;
                synchronized (bridgeImpl) {
                    if (!BridgeImpl.this.started) {
                        return;
                    }
                    if (BridgeImpl.this.session != null) {
                        BridgeImpl.this.session.close();
                    }
                    BridgeImpl.this.started = false;
                    BridgeImpl.this.active = false;
                }
                BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
                BridgeImpl.this.cancelRefs();
                if (BridgeImpl.this.queue != null) {
                    BridgeImpl.this.queue.deliverAsync();
                }
            }
            catch (Exception e) {
                log.error("Failed to stop bridge", e);
            }
        }
    }
}

