/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.Collections;
import java.util.List;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.stomp.StompProtocolManager;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Connection;

class StompConnection
implements RemotingConnection {
    private static final Logger log = Logger.getLogger(StompConnection.class);
    private final StompProtocolManager manager;
    private final Connection transportConnection;
    private String login;
    private String passcode;
    private String clientID;
    private boolean valid;
    private boolean destroyed = false;

    StompConnection(Connection transportConnection, StompProtocolManager manager) {
        this.transportConnection = transportConnection;
        this.manager = manager;
    }

    @Override
    public void addCloseListener(CloseListener listener) {
    }

    @Override
    public void addFailureListener(FailureListener listener) {
    }

    @Override
    public boolean checkDataReceived() {
        return true;
    }

    @Override
    public HornetQBuffer createBuffer(int size) {
        return HornetQBuffers.dynamicBuffer(size);
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.transportConnection.close();
        this.manager.cleanup(this);
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void fail(HornetQException me) {
    }

    @Override
    public void flush() {
    }

    @Override
    public List<FailureListener> getFailureListeners() {
        return Collections.emptyList();
    }

    @Override
    public Object getID() {
        return this.transportConnection.getID();
    }

    @Override
    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    @Override
    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        return false;
    }

    @Override
    public boolean removeFailureListener(FailureListener listener) {
        return false;
    }

    @Override
    public void setFailureListeners(List<FailureListener> listeners) {
    }

    @Override
    public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
        this.manager.handleBuffer(this, buffer);
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.login;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

