/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.nullpm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.persistence.impl.nullpm.NullStorageLargeServerMessage;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.utils.UUID;

public class NullStorageManager
implements StorageManager {
    private final AtomicLong idSequence = new AtomicLong(0L);
    private UUID id;
    private volatile boolean started;

    @Override
    public UUID getPersistentID() {
        return this.id;
    }

    @Override
    public void setPersistentID(UUID id) {
        this.id = id;
    }

    public void sync() {
    }

    @Override
    public void addQueueBinding(Binding queueBinding) throws Exception {
    }

    @Override
    public void deleteQueueBinding(long queueBindingID) throws Exception {
    }

    @Override
    public void commit(long txID) throws Exception {
    }

    @Override
    public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> queueBindingInfos, List<GroupingInfo> groupingInfos) throws Exception {
        return new JournalLoadInformation();
    }

    @Override
    public void prepare(long txID, Xid xid) throws Exception {
    }

    @Override
    public void rollback(long txID) throws Exception {
    }

    @Override
    public void storeReference(long queueID, long messageID, boolean last) throws Exception {
    }

    @Override
    public void storeReferenceTransactional(long txID, long queueID, long messageID) throws Exception {
    }

    @Override
    public void storeAcknowledge(long queueID, long messageID) throws Exception {
    }

    public void storeMessageReferenceScheduled(long queueID, long messageID, long scheduledDeliveryTime) throws Exception {
    }

    @Override
    public void storeAcknowledgeTransactional(long txID, long queueID, long messageiD) throws Exception {
    }

    @Override
    public void deleteMessage(long messageID) throws Exception {
    }

    @Override
    public void deletePageTransactional(long txID, long messageID) throws Exception {
    }

    @Override
    public void storeMessage(ServerMessage message) throws Exception {
    }

    @Override
    public void storeMessageTransactional(long txID, ServerMessage message) throws Exception {
    }

    @Override
    public void updateScheduledDeliveryTime(MessageReference ref) throws Exception {
    }

    @Override
    public void updateScheduledDeliveryTimeTransactional(long txID, MessageReference ref) throws Exception {
    }

    @Override
    public void storePageTransaction(long txID, PageTransactionInfo pageTransaction) throws Exception {
    }

    public void updatePageTransaction(long txID, PageTransactionInfo pageTransaction) throws Exception {
    }

    @Override
    public void updateDeliveryCount(MessageReference ref) throws Exception {
    }

    @Override
    public void storeDuplicateID(SimpleString address, byte[] duplID, long recordID) throws Exception {
    }

    @Override
    public void storeDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
    }

    public void updateDuplicateID(SimpleString address, byte[] duplID, long recordID) throws Exception {
    }

    @Override
    public void updateDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
    }

    @Override
    public long storeHeuristicCompletion(Xid xid, boolean isCommit) throws Exception {
        return this.generateUniqueID();
    }

    @Override
    public void deleteHeuristicCompletion(long txID) throws Exception {
    }

    @Override
    public LargeServerMessage createLargeMessage() {
        return new NullStorageLargeServerMessage();
    }

    @Override
    public LargeServerMessage createLargeMessage(long id, byte[] header) {
        NullStorageLargeServerMessage largeMessage = new NullStorageLargeServerMessage();
        HornetQBuffer headerBuffer = HornetQBuffers.wrappedBuffer(header);
        largeMessage.decodeHeadersAndProperties(headerBuffer);
        largeMessage.setMessageID(id);
        return largeMessage;
    }

    @Override
    public long generateUniqueID() {
        long id = this.idSequence.getAndIncrement();
        return id;
    }

    @Override
    public long getCurrentUniqueID() {
        return this.idSequence.get();
    }

    public void setUniqueIDSequence(long id) {
        this.idSequence.set(id);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Not started");
        }
        this.id = null;
        this.idSequence.set(0L);
        this.started = false;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public void deleteMessageTransactional(long txID, long messageID, long queueID) throws Exception {
    }

    @Override
    public JournalLoadInformation loadMessageJournal(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, Queue> queues, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap) throws Exception {
        return new JournalLoadInformation();
    }

    @Override
    public void deleteDuplicateIDTransactional(long txID, long recordID) throws Exception {
    }

    @Override
    public void deleteDuplicateID(long recordID) throws Exception {
    }

    @Override
    public JournalLoadInformation[] loadInternalOnly() throws Exception {
        return null;
    }

    @Override
    public boolean isReplicated() {
        return false;
    }

    public void completeOperations() {
    }

    @Override
    public void pageClosed(SimpleString storeName, int pageNumber) {
    }

    @Override
    public void pageDeleted(SimpleString storeName, int pageNumber) {
    }

    @Override
    public void pageWrite(PagedMessage message, int pageNumber) {
    }

    @Override
    public void addGrouping(GroupBinding groupBinding) throws Exception {
    }

    @Override
    public void deleteGrouping(GroupBinding groupBinding) throws Exception {
    }

    @Override
    public void waitOnOperations(long timeout) throws Exception {
    }

    public void setReplicator(ReplicationManager replicator) {
        throw new IllegalStateException("Null Persistence should never be used as replicated");
    }

    @Override
    public void afterCompleteOperations(IOAsyncTask run) {
        run.done();
    }

    @Override
    public void waitOnOperations() throws Exception {
    }

    @Override
    public OperationContext getContext() {
        return null;
    }

    @Override
    public OperationContext newContext(Executor executor) {
        return null;
    }

    @Override
    public void setContext(OperationContext context) {
    }

    @Override
    public void clearContext() {
    }

    @Override
    public List<PersistedAddressSetting> recoverAddressSettings() throws Exception {
        return Collections.emptyList();
    }

    @Override
    public void storeAddressSetting(PersistedAddressSetting addressSetting) throws Exception {
    }

    @Override
    public List<PersistedRoles> recoverPersistedRoles() throws Exception {
        return Collections.emptyList();
    }

    @Override
    public void storeSecurityRoles(PersistedRoles persistedRoles) throws Exception {
    }

    @Override
    public void deleteAddressSetting(SimpleString addressMatch) throws Exception {
    }

    @Override
    public void deleteSecurityRoles(SimpleString addressMatch) throws Exception {
    }
}

