/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AbstractJournalUpdateTask;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.dataformat.ByteArrayEncoding;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecord;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalCompleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalDeleteRecord;
import org.hornetq.core.journal.impl.dataformat.JournalDeleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalRollbackRecordTX;

public class JournalCleaner
extends AbstractJournalUpdateTask {
    private final HashMap<Long, AtomicInteger> transactionCounter = new HashMap();

    protected JournalCleaner(SequentialFileFactory fileFactory, JournalImpl journal, Set<Long> recordsSnapshot, long nextOrderingID) throws Exception {
        super(fileFactory, journal, recordsSnapshot, nextOrderingID);
        this.openFile();
    }

    @Override
    public void markAsDataFile(JournalFile file) {
    }

    @Override
    public void onReadAddRecord(RecordInfo info) throws Exception {
        if (this.lookupRecord(info.id)) {
            this.writeEncoder(new JournalAddRecord(true, info.id, info.getUserRecordType(), new ByteArrayEncoding(info.data)));
        }
    }

    @Override
    public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
        if (this.lookupRecord(recordInfo.id)) {
            this.incrementTransactionCounter(transactionID);
            this.writeEncoder(new JournalAddRecordTX(true, transactionID, recordInfo.id, recordInfo.getUserRecordType(), new ByteArrayEncoding(recordInfo.data)));
        }
    }

    @Override
    public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
        int txcounter = this.getTransactionCounter(transactionID);
        this.writeEncoder(new JournalCompleteRecordTX(true, transactionID, null), txcounter);
    }

    @Override
    public void onReadDeleteRecord(long recordID) throws Exception {
        this.writeEncoder(new JournalDeleteRecord(recordID));
    }

    @Override
    public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
        this.incrementTransactionCounter(transactionID);
        this.writeEncoder(new JournalDeleteRecordTX(transactionID, recordInfo.id, new ByteArrayEncoding(recordInfo.data)));
    }

    @Override
    public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
        int txcounter = this.getTransactionCounter(transactionID);
        this.writeEncoder(new JournalCompleteRecordTX(false, transactionID, new ByteArrayEncoding(extraData)), txcounter);
    }

    @Override
    public void onReadRollbackRecord(long transactionID) throws Exception {
        this.writeEncoder(new JournalRollbackRecordTX(transactionID));
    }

    @Override
    public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
        if (this.lookupRecord(recordInfo.id)) {
            this.writeEncoder(new JournalAddRecord(false, recordInfo.id, recordInfo.userRecordType, new ByteArrayEncoding(recordInfo.data)));
        }
    }

    @Override
    public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
        if (this.lookupRecord(recordInfo.id)) {
            this.incrementTransactionCounter(transactionID);
            this.writeEncoder(new JournalAddRecordTX(false, transactionID, recordInfo.id, recordInfo.userRecordType, new ByteArrayEncoding(recordInfo.data)));
        }
    }

    protected int incrementTransactionCounter(long transactionID) {
        AtomicInteger counter = this.transactionCounter.get(transactionID);
        if (counter == null) {
            counter = new AtomicInteger(0);
            this.transactionCounter.put(transactionID, counter);
        }
        return counter.incrementAndGet();
    }

    protected int getTransactionCounter(long transactionID) {
        AtomicInteger counter = this.transactionCounter.get(transactionID);
        if (counter == null) {
            return 0;
        }
        return counter.intValue();
    }
}

