/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.component.IterationStateHolder;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.event.AjaxListener;
import org.ajax4jsf.event.AjaxSource;
import org.ajax4jsf.renderkit.RendererUtils;

public abstract class UIAjaxForm
extends UIForm
implements AjaxComponent,
AjaxSource,
IterationStateHolder {
    public static final String COMPONENT_TYPE = "org.ajax4jsf.Form";
    public static final String FOCUS_DATA_ID = "_A4J.AJAX.focus";

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.decode(context);
        if (this.mustProcessed(context)) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processDecodes(context);
            }
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this.mustProcessed(context)) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processValidators(context);
            }
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this.mustProcessed(context)) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processUpdates(context);
            }
        }
    }

    private boolean mustProcessed(FacesContext context) {
        return this.isSubmitted();
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof AjaxEvent) {
            String focus;
            FacesContext context = this.getFacesContext();
            this.setupReRender(context);
            Object data = this.getData();
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
            if (null != data) {
                ajaxContext.setResponseData(data);
            }
            if (null != (focus = this.getFocus())) {
                UIComponent focusComponent = RendererUtils.getInstance().findComponentFor((UIComponent)this, focus);
                if (null != focusComponent) {
                    focus = focusComponent.getClientId(context);
                }
                ajaxContext.getResponseDataMap().put(FOCUS_DATA_ID, focus);
            }
            ajaxContext.setOncomplete((Object)this.getOncomplete());
        }
    }

    protected void setupReRender() {
        FacesContext context = this.getFacesContext();
        AjaxContext.getCurrentInstance((FacesContext)context).addRegionsFromComponent((UIComponent)this);
    }

    protected void setupReRender(FacesContext facesContext) {
        AjaxContext.getCurrentInstance((FacesContext)facesContext).addRegionsFromComponent((UIComponent)this);
        this.setupReRender();
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public AjaxListener[] getAjaxListeners() {
        AjaxListener[] al = (AjaxListener[])this.getFacesListeners(AjaxListener.class);
        return al;
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public abstract boolean isAjaxSubmit();

    public abstract void setAjaxSubmit(boolean var1);

    public Object getIterationState() {
        return this.isSubmitted() ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setIterationState(Object state) {
        this.setSubmitted(Boolean.TRUE.equals(state));
    }
}

