/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultipleVFSParsingDeployer<T>
extends AbstractVFSParsingDeployer<T> {
    private Map<String, Class<?>> mappings;
    private Class<?> suffixClass;

    public MultipleVFSParsingDeployer(Class<T> output, Map<String, Class<?>> mappings) {
        this(output, mappings, null, null);
    }

    public MultipleVFSParsingDeployer(Class<T> output, Map<String, Class<?>> mappings, String suffix, Class<?> suffixClass) {
        super(output);
        if (mappings == null || mappings.isEmpty()) {
            throw new IllegalArgumentException("Illegal mappings");
        }
        if (suffix != null && suffixClass == null) {
            throw new IllegalArgumentException("Null suffix class");
        }
        this.mappings = mappings;
        this.setNames(mappings.keySet());
        this.setSuffix(suffix);
        this.suffixClass = suffixClass;
    }

    protected Class<?> matchFileToClass(DeploymentUnit unit, VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        return this.matchFileToClass(unit, file.getName(), true);
    }

    @Override
    protected Class<?> matchFileToClass(DeploymentUnit unit, String fileName) {
        return this.matchFileToClass(unit, fileName, false);
    }

    protected Class<?> matchFileToClass(DeploymentUnit unit, String fileName, boolean throwException) {
        Class<?> result;
        if (fileName == null) {
            throw new IllegalArgumentException("Null file name");
        }
        Map<String, Class<?>> altMappingsMap = MultipleVFSParsingDeployer.getAltMappings(unit);
        if (altMappingsMap != null && (result = altMappingsMap.get(fileName)) != null) {
            return result;
        }
        result = this.mappings.get(fileName);
        if (result == null && this.getSuffix() != null && fileName.endsWith(this.getSuffix())) {
            result = this.suffixClass;
        }
        if (result == null && throwException) {
            throw new IllegalArgumentException("Should not be here, file name '" + fileName + "' must macth some mapping " + this.mappings + " or suffix " + this.getSuffix());
        }
        return result;
    }

    @Override
    protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception {
        Class<?> expectedType = this.matchFileToClass((DeploymentUnit)unit, file);
        if (!this.getOutput().isAssignableFrom(expectedType)) {
            throw new IllegalArgumentException("Matched " + expectedType + " which is not assignable to output " + this.getOutput());
        }
        if (root != null && !expectedType.isInstance(root)) {
            throw new IllegalArgumentException("Illegal root type: " + root + ", expecting " + expectedType);
        }
        return (T)this.parse(expectedType, file, root);
    }

    protected abstract <U> U parse(Class<U> var1, VirtualFile var2, Object var3) throws Exception;

    @Override
    protected T mergeFiles(VFSDeploymentUnit unit, T root, List<VirtualFile> files, Set<String> missingFiles) throws Exception {
        HashMap metadata = new HashMap();
        for (VirtualFile file : files) {
            Class<?> clazz = this.matchFileToClass((DeploymentUnit)unit, file);
            ArrayList instances = (ArrayList)metadata.get(clazz);
            if (instances == null) {
                instances = new ArrayList();
                metadata.put(clazz, instances);
            }
            Object instance = this.parse(clazz, file, root);
            instances.add(instance);
        }
        return this.mergeMetaData(unit, root, metadata, missingFiles);
    }

    protected T mergeMetaData(VFSDeploymentUnit unit, T root, Map<Class<?>, List<Object>> metadata, Set<String> missingFiles) throws Exception {
        return this.mergeMetaData(unit, metadata);
    }

    protected abstract T mergeMetaData(VFSDeploymentUnit var1, Map<Class<?>, List<Object>> var2) throws Exception;

    protected <S> S getInstance(Map<Class<?>, List<Object>> metadata, Class<S> clazz) {
        List<Object> instances = metadata.get(clazz);
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        if (instances.size() > 1) {
            throw new IllegalArgumentException("Expecting single instance: " + metadata);
        }
        return clazz.cast(instances.iterator().next());
    }

    public Map<String, Class<?>> getMappings() {
        return this.mappings;
    }

    public Class<?> getSuffixClass() {
        return this.suffixClass;
    }
}

