/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HAPartitionLocator {
    private static final Logger log = Logger.getLogger(HAPartitionLocator.class);
    private static HAPartitionLocator sharedInstance = new HAPartitionLocator();
    public static final String JNDI_CONTEXT_NAME = "/HAPartition/";
    private Map<String, HAPartition> registeredPartitions = new ConcurrentHashMap<String, HAPartition>();

    public static HAPartitionLocator getHAPartitionLocator() {
        return sharedInstance;
    }

    public static final String getStandardJndiBinding(String partitionName) {
        return JNDI_CONTEXT_NAME + partitionName;
    }

    protected static void setSharedInstance(HAPartitionLocator shared) {
        if (shared == null) {
            throw new IllegalArgumentException("shared cannot be null");
        }
        sharedInstance = shared;
    }

    protected HAPartitionLocator() {
    }

    public HAPartition getHAPartition(String partitionName, Hashtable<?, ?> jndiProperties) {
        HAPartition partition = this.findInRegistry(partitionName);
        if (partition == null) {
            try {
                partition = this.findInJndi(partitionName, jndiProperties);
            }
            catch (NamingException e) {
                log.error((Object)("Problem finding partition " + partitionName + " in JNDI"), (Throwable)e);
            }
        }
        if (partition == null) {
            throw new IllegalStateException("Partition " + partitionName + " not found");
        }
        return partition;
    }

    public void registerHAPartition(HAPartition partition) {
        if (partition != null) {
            this.registeredPartitions.put(partition.getPartitionName(), partition);
        }
    }

    public void deregisterHAPartition(HAPartition partition) {
        if (partition != null) {
            this.registeredPartitions.remove(partition.getPartitionName());
        }
    }

    protected HAPartition findInRegistry(String partitionName) {
        return this.registeredPartitions.get(partitionName);
    }

    protected HAPartition findInJndi(String partitionName, Hashtable<?, ?> jndiProperties) throws NamingException {
        try {
            InitialContext ctx = new InitialContext(jndiProperties);
            return (HAPartition)ctx.lookup(HAPartitionLocator.getStandardJndiBinding(partitionName));
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }
}

