/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.test.support;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.plugins.filter.PatternClassFilter;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.PackageInformation;
import org.jboss.classloader.spi.filter.ClassFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockClassLoaderPolicy
extends ClassLoaderPolicy {
    private String name;
    private String prefix = "";
    private List<? extends DelegateLoader> delegates;
    private String[] paths;
    private String[] included;
    private String[] excluded;
    private String[] packageNames;
    private boolean importAll;
    private ClassFilter nonJDKFilter;

    public MockClassLoaderPolicy() {
        this(null);
    }

    public MockClassLoaderPolicy(String name) {
        this(name, new String[]{"org\\.jboss\\..+"}, new String[]{"org/jboss/.+"}, new String[]{"org\\.jboss", "org\\.jboss\\..*"});
    }

    public MockClassLoaderPolicy(String name, String[] classPatterns, String[] resourcePatterns, String[] packagePatterns) {
        this(name, new PatternClassFilter(classPatterns, resourcePatterns, packagePatterns));
    }

    public MockClassLoaderPolicy(String name, ClassFilter nonJDKFilter) {
        if (name == null) {
            name = "mock";
        }
        this.name = name;
        if (nonJDKFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.nonJDKFilter = nonJDKFilter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<? extends DelegateLoader> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(List<? extends DelegateLoader> delegates) {
        this.delegates = delegates;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void setPath(String path) {
        this.setPaths(path);
    }

    public void setPaths(String ... paths) {
        this.paths = paths;
    }

    public void setPaths(Class<?> ... classes) {
        if (classes == null) {
            this.paths = null;
            return;
        }
        this.paths = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.paths[i] = ClassLoaderUtils.packageNameToPath(classes[i].getName());
        }
    }

    @Override
    public String[] getPackageNames() {
        return this.packageNames;
    }

    public void setPackageNames(String ... packageNames) {
        this.packageNames = packageNames;
    }

    public void setPackageNames(Class<?> ... classes) {
        if (classes == null) {
            this.packageNames = null;
            return;
        }
        this.packageNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.packageNames[i] = ClassLoaderUtils.getClassPackageName(classes[i].getName());
        }
    }

    public void setIncluded(String ... included) {
        this.included = included;
    }

    public void setIncluded(Class<?> ... classes) {
        if (classes == null) {
            this.included = null;
            return;
        }
        this.included = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.included[i] = ClassLoaderUtils.classNameToPath(classes[i].getName());
        }
    }

    public void setExcluded(String ... excluded) {
        this.excluded = excluded;
    }

    public void setExcluded(Class<?> ... classes) {
        if (classes == null) {
            this.excluded = null;
            return;
        }
        this.excluded = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.excluded[i] = ClassLoaderUtils.classNameToPath(classes[i].getName());
        }
    }

    public void setPathsAndPackageNames(Class<?> ... classes) {
        this.setPaths(classes);
        this.setPackageNames(classes);
    }

    public void setPathsAndPackageNames(String ... packages) {
        if (packages == null) {
            this.paths = null;
            this.packageNames = null;
            return;
        }
        this.paths = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            this.paths[i] = packages[i].replace('.', '/');
        }
        this.setPackageNames(packages);
    }

    @Override
    public boolean isImportAll() {
        return this.importAll;
    }

    public void setImportAll(boolean importAll) {
        this.importAll = importAll;
    }

    @Override
    public URL getResource(String path) {
        if (this.paths == null) {
            return null;
        }
        if (this.excluded != null) {
            for (String excludedPath : this.excluded) {
                if (!excludedPath.equals(path)) continue;
                return null;
            }
        }
        if (this.included != null) {
            boolean include = false;
            for (String includedPath : this.included) {
                if (!includedPath.equals(path)) continue;
                include = true;
                break;
            }
            if (!include) {
                return null;
            }
        }
        for (int i = 0; i < this.paths.length; ++i) {
            if (!path.startsWith(this.paths[i])) continue;
            return this.getClass().getClassLoader().getResource(this.prefix + path);
        }
        return null;
    }

    @Override
    public void getResources(String path, Set<URL> urls) throws IOException {
        if (this.paths == null) {
            return;
        }
        if (this.excluded != null) {
            for (String excludedPath : this.excluded) {
                if (!excludedPath.equals(path)) continue;
                return;
            }
        }
        if (this.included != null) {
            boolean include = false;
            for (String includedPath : this.included) {
                if (!includedPath.equals(path)) continue;
                include = true;
                break;
            }
            if (!include) {
                return;
            }
        }
        ClassLoader parent = this.getClass().getClassLoader();
        for (int i = 0; i < this.paths.length; ++i) {
            if (!path.startsWith(this.paths[i])) continue;
            Enumeration<URL> enumeration = parent.getResources(this.prefix + path);
            while (enumeration.hasMoreElements()) {
                urls.add(enumeration.nextElement());
            }
        }
    }

    @Override
    protected ProtectionDomain getProtectionDomain(String className, String path) {
        Class<?> clazz;
        try {
            clazz = this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Could not load class: " + className, e);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        }, this.getAccessControlContext());
    }

    @Override
    public PackageInformation getPackageInformation(String packageName) {
        PackageInformation pi = new PackageInformation(packageName);
        pi.implTitle = this.name;
        return pi;
    }

    @Override
    protected ClassLoader isJDKRequest(String name) {
        if (this.nonJDKFilter.matchesClassName(name)) {
            return null;
        }
        return super.isJDKRequest(name);
    }

    @Override
    public ObjectName getObjectName() {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("name", "'" + this.name + "'");
            properties.put("domain", "\"" + this.getDomainName() + "\"");
            return ObjectName.getInstance("jboss.classloader", properties);
        }
        catch (MalformedObjectNameException e) {
            throw new Error("Error creating object name", e);
        }
    }

    @Override
    public void toLongString(StringBuilder builder) {
        builder.append(" name=").append(this.name);
        if (this.prefix.length() > 0) {
            builder.append(" prefix=").append(this.prefix);
        }
        if (this.paths != null) {
            builder.append(" paths=").append(Arrays.asList(this.paths));
        }
        if (this.included != null) {
            builder.append(" included=").append(Arrays.asList(this.included));
        }
        if (this.excluded != null) {
            builder.append(" excluded=").append(Arrays.asList(this.excluded));
        }
        super.toLongString(builder);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

