/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="inventoryEventListener")
@Scope(value=ScopeType.APPLICATION)
public class EmbeddedInventoryEventListener
implements InventoryEventListener {
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean navTreeInitialized;

    public void resourcesAdded(Set<Resource> resources) {
        for (Resource resource : resources) {
            PackageType creationPackageType;
            ResourceType resourceType;
            if (this.navTreeInitialized) {
                Events.instance().raiseEvent("resourceCreated", new Object[]{resource.getResourceType(), resource.getParentResource()});
            }
            if (!EmbeddedInventoryEventListener.isContentBacked(resourceType = resource.getResourceType()) || (creationPackageType = EmbeddedInventoryEventListener.getCreationPackageType(resourceType)) == null) continue;
            try {
                PluginContainer.getInstance().getContentManager().executeResourcePackageDiscoveryImmediately(resource.getId(), creationPackageType.getName());
            }
            catch (PluginContainerException e) {
                this.log.error((Object)("Failed to discover underlying " + creationPackageType.getName() + " package for " + resourceType.getName() + " Resource."), (Throwable)e);
            }
        }
    }

    public void resourcesRemoved(Set<Resource> resources) {
        if (this.navTreeInitialized) {
            for (Resource resource : resources) {
                Events.instance().raiseEvent("resourceDeleted", new Object[]{resource});
            }
        }
    }

    public void resourceActivated(Resource resource) {
    }

    public void resourceDeactivated(Resource resource) {
    }

    @Observer(value={"navTreeInitialized"})
    public void navTreeInitialized() {
        this.navTreeInitialized = true;
    }

    private static boolean isContentBacked(ResourceType resourceType) {
        return resourceType.isCreatable() && resourceType.getCreationDataType() == ResourceCreationDataType.CONTENT;
    }

    @Nullable
    private static PackageType getCreationPackageType(ResourceType resourceType) {
        Set packageTypes = resourceType.getPackageTypes();
        for (PackageType packageType : packageTypes) {
            if (!packageType.isCreationData()) continue;
            return packageType;
        }
        return null;
    }
}

