/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.log.LogEvent;
import org.apache.log.output.db.ColumnInfo;
import org.apache.log.output.db.DefaultJDBCTarget;

public class NormalizedJDBCTarget
extends DefaultJDBCTarget {
    private HashMap m_categoryIDs = new HashMap();
    private HashMap m_priorityIDs = new HashMap();

    public NormalizedJDBCTarget(DataSource dataSource, String table, ColumnInfo[] columns) {
        super(dataSource, table, columns);
    }

    protected void specifyColumn(PreparedStatement statement, int index, LogEvent event) throws SQLException {
        ColumnInfo info = this.getColumn(index);
        int id = 0;
        String tableName = null;
        switch (info.getType()) {
            case 2: {
                tableName = this.getTable() + "_" + "category" + "_SET";
                id = this.getID(tableName, this.m_categoryIDs, event.getCategory());
                statement.setInt(index + 1, id);
                break;
            }
            case 8: {
                tableName = this.getTable() + "_" + "priority" + "_SET";
                id = this.getID(tableName, this.m_priorityIDs, event.getPriority().getName());
                statement.setInt(index + 1, id);
                break;
            }
            default: {
                super.specifyColumn(statement, index, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int getID(String tableName, HashMap idMap, String instance) throws SQLException {
        int n;
        Statement statement;
        block22: {
            ResultSet resultSet;
            block20: {
                int n2;
                block21: {
                    Integer id = (Integer)idMap.get(instance);
                    if (null != id) {
                        return id;
                    }
                    statement = null;
                    resultSet = null;
                    try {
                        statement = this.getConnection().createStatement();
                        String querySql = "SELECT ID FROM " + tableName + " WHERE NAME='" + instance + "'";
                        resultSet = statement.executeQuery(querySql);
                        if (!resultSet.next()) break block20;
                        Integer newID = new Integer(resultSet.getInt(1));
                        idMap.put(instance, newID);
                        n2 = newID;
                        if (null == resultSet) break block21;
                    }
                    catch (Throwable throwable) {
                        block23: {
                            if (null != resultSet) {
                                try {
                                    resultSet.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (null == statement) break block23;
                            try {
                                statement.close();
                            }
                            catch (Exception e) {}
                        }
                        throw throwable;
                    }
                    try {
                        resultSet.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return n2;
            }
            resultSet.close();
            String maxQuerySql = "SELECT MAX(ID) FROM " + tableName;
            resultSet = statement.executeQuery(maxQuerySql);
            int max = 0;
            if (resultSet.next()) {
                max = resultSet.getInt(1);
            }
            resultSet.close();
            int newID = max + 1;
            String insertSQL = "INSERT INTO " + tableName + " (ID, NAME) VALUES ( " + newID + ", '" + instance + "')";
            statement.executeUpdate(insertSQL);
            idMap.put(instance, new Integer(newID));
            n = newID;
            if (null == resultSet) break block22;
            try {
                resultSet.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null != statement) {
            try {
                statement.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return n;
    }
}

