/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.ServerSocketFactory;
import org.jboss.remoting.security.ServerSocketFactoryMBean;
import org.jboss.remoting.util.SecurityUtility;

public class ServerSocketFactoryWrapper
extends ServerSocketFactory {
    private ServerSocketFactoryMBean serverSocketFactory = null;

    public ServerSocketFactoryWrapper(ServerSocketFactoryMBean serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    @Override
    public ServerSocket createServerSocket(int i) throws IOException {
        return ServerSocketFactoryWrapper.createServerSocket(this.serverSocketFactory, i);
    }

    @Override
    public ServerSocket createServerSocket(int i, int i1) throws IOException {
        return ServerSocketFactoryWrapper.createServerSocket(this.serverSocketFactory, i, i1);
    }

    @Override
    public ServerSocket createServerSocket(int i, int i1, InetAddress inetAddress) throws IOException {
        return ServerSocketFactoryWrapper.createServerSocket(this.serverSocketFactory, i, i1, inetAddress);
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return ServerSocketFactoryWrapper.createServerSocket(this.serverSocketFactory);
    }

    public ServerSocketFactoryMBean getDelegate() {
        return this.serverSocketFactory;
    }

    private static ServerSocket createServerSocket(final ServerSocketFactoryMBean ssf) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            return ssf.createServerSocket();
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return ssf.createServerSocket();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static ServerSocket createServerSocket(final ServerSocketFactoryMBean ssf, final int port) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            return ssf.createServerSocket(port);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ssf.createServerSocket(port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static ServerSocket createServerSocket(final ServerSocketFactoryMBean ssf, final int port, final int backlog) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            return ssf.createServerSocket(port, backlog);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ssf.createServerSocket(port, backlog);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static ServerSocket createServerSocket(final ServerSocketFactoryMBean ssf, final int port, final int backlog, final InetAddress inetAddress) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            return ssf.createServerSocket(port, backlog, inetAddress);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ssf.createServerSocket(port, backlog, inetAddress);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

