/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.infinispan;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.CacheConfig;
import org.jboss.ejb3.cache.ClusteredStatefulCache;
import org.jboss.ejb3.cache.infinispan.CacheSource;
import org.jboss.ejb3.cache.infinispan.LockManagerSource;
import org.jboss.ejb3.stateful.NestedStatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ha.framework.server.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.ha.framework.server.lock.TimeoutException;
import org.jboss.ha.ispn.invoker.CacheInvoker;
import org.jboss.logging.Logger;
import org.jboss.util.loading.ContextClassLoaderSwitcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class InfinispanStatefulCache
implements ClusteredStatefulCache {
    private static final ThreadLocal<Boolean> localActivity = new ThreadLocal();
    private static final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    Map<Object, Future<Void>> removeFutures;
    Map<Object, Future<Void>> evictFutures;
    Cache<Object, StatefulBeanContext> cache;
    Logger log;
    final ThreadFactory threadFactory;
    private final CacheSource cacheSource;
    private final LockManagerSource lockManagerSource;
    private final CacheInvoker invoker;
    private final AtomicInteger createCount = new AtomicInteger(0);
    private final AtomicInteger passivatedCount = new AtomicInteger(0);
    private final AtomicInteger removeCount = new AtomicInteger(0);
    private final AtomicBoolean resetTotalSize = new AtomicBoolean(true);
    private volatile int totalSize = 0;
    private StatefulContainer container;
    private CacheConfig cacheConfig;
    private ScheduledExecutorService executor;
    private SharedLocalYieldingClusterLockManager lockManager;
    private WeakReference<ClassLoader> classLoaderRef;

    public InfinispanStatefulCache(CacheSource cacheSource, LockManagerSource lockManagerSource, CacheInvoker invoker, ThreadFactory threadFactory) {
        this.cacheSource = cacheSource;
        this.lockManagerSource = lockManagerSource;
        this.invoker = invoker;
        this.threadFactory = threadFactory;
    }

    public void initialize(EJBContainer container) throws Exception {
        this.container = (StatefulContainer)container;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.container.getEjbName()));
        this.cache = this.cacheSource.getCache(this.container);
        this.lockManager = this.lockManagerSource.getLockManager(this.cache);
        this.cacheConfig = (CacheConfig)this.container.getAnnotation(CacheConfig.class);
        if (this.cacheConfig.removalTimeoutSeconds() > 0L) {
            this.removeFutures = new ConcurrentHashMap<Object, Future<Void>>();
        }
        if (this.cacheConfig.idleTimeoutSeconds() > 0L) {
            this.evictFutures = new ConcurrentHashMap<Object, Future<Void>>();
        }
    }

    public void start() {
        this.classLoaderRef = new WeakReference<ClassLoader>(this.container.getClassloader());
        if (!this.cache.getStatus().allowInvocations()) {
            this.cache.start();
        }
        this.cache.addListener((Object)this);
        if (this.removeFutures != null || this.evictFutures != null) {
            final String threadName = "SFSB Removal/Eviction Thread - " + this.container.getObjectName().getCanonicalName();
            ThreadFactory threadFactory = new ThreadFactory(){

                public Thread newThread(Runnable task) {
                    final Thread thread = InfinispanStatefulCache.this.threadFactory.newThread(task);
                    PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            thread.setName(threadName);
                            return null;
                        }
                    };
                    AccessController.doPrivileged(action);
                    return thread;
                }
            };
            this.executor = Executors.newScheduledThreadPool(1, threadFactory);
        }
        this.resetTotalSize.set(true);
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.cache != null) {
            this.cache.removeListener((Object)this);
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).clear();
            this.cache.stop();
        }
        if (this.classLoaderRef != null) {
            this.classLoaderRef.clear();
        }
    }

    public StatefulBeanContext peek(Object id) throws NoSuchEJBException {
        this.trace("peek(%s)", id);
        return this.get(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StatefulBeanContext bean) {
        this.trace("release(%s)", bean.getId());
        StatefulBeanContext statefulBeanContext = bean;
        synchronized (statefulBeanContext) {
            this.setInUse(bean, false);
        }
        this.releaseSessionOwnership(bean.getId(), false);
    }

    public void replicate(StatefulBeanContext bean) {
        this.trace("replicate(%s)", bean.getId());
        if (bean instanceof NestedStatefulBeanContext) {
            throw new IllegalArgumentException("Received unexpected replicate call for nested context " + bean.getId());
        }
        this.putInCache(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(final Object id) {
        this.trace("remove(%s)", id);
        Operation<StatefulBeanContext> operation = new Operation<StatefulBeanContext>(){

            public StatefulBeanContext invoke(Cache<Object, StatefulBeanContext> cache) {
                return (StatefulBeanContext)cache.get(id);
            }
        };
        this.acquireSessionOwnership(id, false);
        boolean remove = false;
        try {
            Future<Void> future;
            StatefulBeanContext bean = (StatefulBeanContext)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation);
            if (bean == null) {
                throw new NoSuchEJBException("Could not find bean: " + id);
            }
            if (!bean.isRemoved()) {
                this.container.destroy(bean);
            } else {
                this.trace("remove(%s): was already removed from pool", id);
            }
            if (bean.getCanRemoveFromCache()) {
                operation = new Operation<StatefulBeanContext>(){

                    public StatefulBeanContext invoke(Cache<Object, StatefulBeanContext> cache) {
                        return (StatefulBeanContext)cache.remove(id);
                    }
                };
                this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation);
                remove = true;
            } else {
                this.putInCache(bean);
                this.trace("remove(%s): cannot yet be removed from the cache", id);
            }
            if (this.removeFutures != null && (future = this.removeFutures.remove(id)) != null) {
                future.cancel(false);
            }
            this.removeCount.incrementAndGet();
            this.resetTotalSize.set(true);
        }
        finally {
            this.releaseSessionOwnership(id, remove);
        }
    }

    public StatefulBeanContext create(Class<?>[] initTypes, Object[] initValues) {
        StatefulBeanContext bean = this.create();
        this.trace("Caching context %s of type %s", bean.getId(), bean.getClass().getName());
        this.acquireSessionOwnership(bean.getId(), true);
        try {
            this.putInCache(bean);
            this.setInUse(bean, true);
            this.createCount.incrementAndGet();
            this.resetTotalSize.set(true);
            return bean;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatefulBeanContext create() {
        CacheConfig config;
        StatefulBeanContext bean = (StatefulBeanContext)this.container.createBeanContext();
        DistributionManager manager = this.cache.getAdvancedCache().getDistributionManager();
        if (manager != null) {
            while (!manager.isLocal(bean.getId())) {
                bean = new InfinispanStatefulBeanContext(this.container, bean.getInstance());
            }
        }
        if ((config = (CacheConfig)this.container.getAnnotation(CacheConfig.class)) != null) {
            bean.setReplicationIsPassivation(config.replicationIsPassivation());
        }
        bean = bean.pushContainedIn();
        this.container.pushContext((BeanContext)bean);
        try {
            this.container.injectBeanContext((BeanContext)bean);
        }
        finally {
            this.container.popContext();
            bean.popContainedIn();
        }
        this.container.invokePostConstruct((BeanContext)bean);
        return bean;
    }

    public StatefulBeanContext get(Object id) throws EJBException {
        this.trace("get(%s)", id);
        if (this.acquireSessionOwnership(id, false) == SharedLocalYieldingClusterLockManager.LockResult.ACQUIRED_FROM_CLUSTER) {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).evict(id);
        }
        return this.get(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext get(Object id, boolean markInUse) throws EJBException {
        this.trace("get(%s, %s)", id, markInUse);
        StatefulBeanContext bean = this.getFromCache(id);
        if (bean == null) {
            throw new NoSuchEJBException(String.format("Could not find stateful bean: %s", id));
        }
        if (markInUse && bean.isRemoved()) {
            throw new NoSuchEJBException(String.format("Could not find stateful bean: %s (bean was marked as removed)", id));
        }
        bean.postReplicate();
        if (markInUse) {
            StatefulBeanContext statefulBeanContext = bean;
            synchronized (statefulBeanContext) {
                this.setInUse(bean, true);
            }
        }
        return bean;
    }

    public int getAvailableCount() {
        int maxSize = this.getMaxSize();
        return maxSize < 0 ? maxSize : maxSize - this.getCurrentSize();
    }

    public int getCacheSize() {
        return this.getTotalSize() - this.getPassivatedCount();
    }

    public int getCreateCount() {
        return this.createCount.get();
    }

    public int getCurrentSize() {
        return this.getCacheSize();
    }

    public int getMaxSize() {
        return this.cacheConfig == null ? -1 : this.cacheConfig.maxSize();
    }

    public int getPassivatedCount() {
        return this.passivatedCount.get();
    }

    public int getRemoveCount() {
        return this.removeCount.get();
    }

    public int getTotalSize() {
        if (this.removeFutures != null) {
            return this.removeFutures.size();
        }
        if (this.resetTotalSize.compareAndSet(true, false)) {
            this.totalSize = this.cache.size();
        }
        return this.totalSize;
    }

    public boolean isStarted() {
        return this.cache != null ? this.cache.getStatus().allowInvocations() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<Object, StatefulBeanContext> event) {
        if (event.isPre()) {
            return;
        }
        if (event.getValue() == null || !(event.getValue() instanceof StatefulBeanContext)) {
            return;
        }
        this.trace("activated(%s)", event.getKey());
        StatefulBeanContext bean = (StatefulBeanContext)event.getValue();
        this.passivatedCount.decrementAndGet();
        this.resetTotalSize.set(true);
        if (localActivity.get() == Boolean.TRUE) {
            ContextClassLoaderSwitcher.SwitchContext switchContext = switcher.getSwitchContext();
            ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
            try {
                if (classLoader != null) {
                    switchContext.setClassLoader(classLoader);
                }
                bean.activateAfterReplication();
            }
            finally {
                if (classLoader != null) {
                    switchContext.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheEntryPassivated
    public void passivated(CacheEntryPassivatedEvent<Object, StatefulBeanContext> event) {
        if (!event.isPre()) {
            return;
        }
        if (event.getValue() == null || !(event.getValue() instanceof StatefulBeanContext)) {
            return;
        }
        Object key = event.getKey();
        this.trace("passivated(%s)", key);
        StatefulBeanContext bean = (StatefulBeanContext)event.getValue();
        ContextClassLoaderSwitcher.SwitchContext switchContext = switcher.getSwitchContext();
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        Boolean active = localActivity.get();
        localActivity.set(Boolean.TRUE);
        try {
            if (!bean.getCanPassivate()) {
                throw new RuntimeException(String.format("Cannot passivate bean %s -- it or one if its children is currently in use", key));
            }
            this.passivatedCount.incrementAndGet();
            this.resetTotalSize.set(true);
            if (classLoader != null) {
                switchContext.setClassLoader(classLoader);
            }
            bean.passivateAfterReplication();
        }
        finally {
            localActivity.set(active);
            if (classLoader != null) {
                switchContext.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatefulBeanContext getFromCache(final Object key) {
        Operation<StatefulBeanContext> operation = new Operation<StatefulBeanContext>(){

            public StatefulBeanContext invoke(Cache<Object, StatefulBeanContext> cache) {
                return (StatefulBeanContext)cache.get(key);
            }
        };
        Boolean active = localActivity.get();
        localActivity.set(Boolean.TRUE);
        try {
            StatefulBeanContext statefulBeanContext = (StatefulBeanContext)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation);
            return statefulBeanContext;
        }
        finally {
            localActivity.set(active);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(final StatefulBeanContext bean) {
        Operation<StatefulBeanContext> operation = new Operation<StatefulBeanContext>(){

            public StatefulBeanContext invoke(Cache<Object, StatefulBeanContext> cache) {
                return (StatefulBeanContext)cache.put(bean.getId(), (Object)bean);
            }
        };
        Boolean active = localActivity.get();
        localActivity.set(Boolean.TRUE);
        try {
            bean.preReplicate();
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation);
            bean.markedForReplication = false;
        }
        finally {
            localActivity.set(active);
        }
    }

    private void setInUse(StatefulBeanContext bean, boolean inUse) {
        Future future;
        bean.setInUse(inUse);
        bean.lastUsed = System.currentTimeMillis();
        Object id = bean.getId();
        if (this.removeFutures != null && (future = (Future)this.removeFutures.put(id, this.executor.schedule(new RemoveTask(id), this.cacheConfig.removalTimeoutSeconds(), TimeUnit.SECONDS))) != null) {
            future.cancel(true);
        }
        if (this.evictFutures != null) {
            Future future2 = future = inUse ? this.evictFutures.remove(id) : (Future)this.evictFutures.put(id, this.executor.schedule(new EvictTask(id), this.cacheConfig.idleTimeoutSeconds(), TimeUnit.SECONDS));
            if (future != null) {
                future.cancel(true);
            }
        }
    }

    private SharedLocalYieldingClusterLockManager.LockResult acquireSessionOwnership(Object id, boolean newLock) {
        if (this.lockManager == null) {
            return null;
        }
        this.trace("Acquiring %slock on %s", newLock ? "new " : "", id);
        try {
            SharedLocalYieldingClusterLockManager.LockResult result = this.lockManager.lock(this.getBeanLockKey(id), this.cache.getConfiguration().getLockAcquisitionTimeout(), newLock);
            this.trace("Lock acquired (%s) on %s", result, id);
            return result;
        }
        catch (TimeoutException e) {
            throw new EJBException("Caught " + ((Object)((Object)e)).getClass().getSimpleName() + " acquiring ownership of " + id, (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EJBException("Interrupted while acquiring ownership of " + id, (Exception)e);
        }
    }

    private void releaseSessionOwnership(Object id, boolean remove) {
        if (this.lockManager != null) {
            this.trace("Releasing %slock on %s", remove ? "and removing " : "", id);
            this.lockManager.unlock(this.getBeanLockKey(id), remove);
            this.trace("Released %slock on %s", remove ? "and removed " : "", id);
        }
    }

    private Serializable getBeanLockKey(Object id) {
        return this.cache.getName() + "/" + id.toString();
    }

    private void trace(String message, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format(message, args));
        }
    }

    public static class InfinispanStatefulBeanContext
    extends StatefulBeanContext {
        InfinispanStatefulBeanContext(StatefulContainer container, Object bean) {
            super(container, bean);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Operation<R>
    extends CacheInvoker.Operation<Object, StatefulBeanContext, R> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EvictTask
    implements Callable<Void> {
        private final Object id;

        EvictTask(Object id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            try {
                InfinispanStatefulCache.this.cache.evict(this.id);
            }
            finally {
                InfinispanStatefulCache.this.evictFutures.remove(this.id);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RemoveTask
    implements Callable<Void> {
        private final Object id;

        RemoveTask(Object id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            try {
                InfinispanStatefulCache.this.remove(this.id);
            }
            finally {
                InfinispanStatefulCache.this.removeFutures.remove(this.id);
            }
            return null;
        }
    }
}

