/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptors;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.interceptors.InterceptorFactory;
import org.jboss.ejb3.interceptors.InterceptorFactoryRef;
import org.jboss.ejb3.interceptors.aop.AbstractInterceptorFactory;
import org.jboss.ejb3.interceptors.aop.BusinessMethodBeanMethodInterceptor;
import org.jboss.ejb3.interceptors.aop.BusinessMethodInterceptorMethodInterceptor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisorHelper;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbackBeanMethodInterceptor;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbackInterceptorMethodInterceptor;
import org.jboss.ejb3.interceptors.aop.NopInterceptor;
import org.jboss.ejb3.interceptors.aop.annotation.DefaultInterceptors;
import org.jboss.ejb3.interceptors.container.ManagedObjectAdvisor;
import org.jboss.ejb3.interceptors.lang.ClassHelper;
import org.jboss.logging.Logger;

public class InterceptorsFactory
extends AbstractInterceptorFactory {
    private static final Logger log = Logger.getLogger(InterceptorsFactory.class);
    private static final Class<? extends Annotation>[] lifeCycleAnnotationClasses = new Class[]{PostActivate.class, PostConstruct.class, PreDestroy.class, PrePassivate.class};

    private List<? extends Interceptor> createInterceptors(Advisor advisor, InterceptorFactory interceptorFactory, Class<?>[] interceptorClasses, List<BusinessMethodInterceptorMethodInterceptor> interceptors, Map<Class<?>, Object> existingInterceptors, Map<Class<? extends Annotation>, List<Interceptor>> lifeCycleInterceptors) throws InstantiationException, IllegalAccessException {
        if (interceptorClasses != null) {
            for (Class<?> interceptorClass : interceptorClasses) {
                Object interceptor = existingInterceptors.get(interceptorClass);
                if (interceptor == null) {
                    interceptor = interceptorFactory.create(advisor, interceptorClass);
                    existingInterceptors.put(interceptorClass, interceptor);
                }
                ExtendedAdvisor interceptorAdvisor = ExtendedAdvisorHelper.getExtendedAdvisor(advisor, interceptor);
                log.debug((Object)("  interceptorAdvisor = " + interceptorAdvisor));
                for (Method method : ClassHelper.getAllMethods(interceptorClass)) {
                    if (interceptorAdvisor.isAnnotationPresent(interceptorClass, method, AroundInvoke.class)) {
                        interceptors.add(new BusinessMethodInterceptorMethodInterceptor(interceptor, method));
                    }
                    for (Class<? extends Annotation> lifeCycleAnnotationClass : lifeCycleAnnotationClasses) {
                        if (!interceptorAdvisor.isAnnotationPresent(interceptorClass, method, lifeCycleAnnotationClass)) continue;
                        lifeCycleInterceptors.get(lifeCycleAnnotationClass).add(new LifecycleCallbackInterceptorMethodInterceptor(interceptor, method));
                    }
                }
            }
        }
        return interceptors;
    }

    @Override
    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        if (advisor instanceof ManagedObjectAdvisor) {
            log.warn((Object)"EJBTHREE-1246: Do not use InterceptorsFactory with a ManagedObjectAdvisor, InterceptorRegistry should be used via the bean container");
            return new NopInterceptor();
        }
        try {
            log.debug((Object)"createPerInstance");
            log.debug((Object)(" advisor " + advisor.getClass().getName()));
            log.debug((Object)(" instanceAdvisor " + this.toString(instanceAdvisor)));
            InterceptorFactoryRef interceptorFactoryRef = (InterceptorFactoryRef)advisor.resolveAnnotation(InterceptorFactoryRef.class);
            if (interceptorFactoryRef == null) {
                throw new IllegalStateException("No InterceptorFactory specified on " + advisor.getName());
            }
            log.debug((Object)("interceptor factory class = " + interceptorFactoryRef.value()));
            InterceptorFactory interceptorFactory = interceptorFactoryRef.value().newInstance();
            HashMap interceptors = new HashMap();
            HashMap<Class<? extends Annotation>, List<Interceptor>> lifeCycleInterceptors = new HashMap<Class<? extends Annotation>, List<Interceptor>>();
            for (Class<? extends Annotation> lifeCycleAnnotationClass : lifeCycleAnnotationClasses) {
                ArrayList list = new ArrayList();
                lifeCycleInterceptors.put(lifeCycleAnnotationClass, list);
            }
            DefaultInterceptors defaultInterceptorsAnnotation = (DefaultInterceptors)advisor.resolveAnnotation(DefaultInterceptors.class);
            ArrayList<BusinessMethodInterceptorMethodInterceptor> defaultInterceptors = new ArrayList<BusinessMethodInterceptorMethodInterceptor>();
            if (defaultInterceptorsAnnotation != null) {
                this.createInterceptors(advisor, interceptorFactory, defaultInterceptorsAnnotation.value(), defaultInterceptors, interceptors, lifeCycleInterceptors);
            }
            log.debug((Object)("Found class interceptors " + defaultInterceptors));
            instanceAdvisor.getMetaData().addMetaData(InterceptorsFactory.class, (Object)"defaultInterceptors", defaultInterceptors);
            Interceptors interceptorsAnnotation = (Interceptors)advisor.resolveAnnotation(Interceptors.class);
            ArrayList<BusinessMethodInterceptorMethodInterceptor> classInterceptors = new ArrayList<BusinessMethodInterceptorMethodInterceptor>();
            if (interceptorsAnnotation != null) {
                this.createInterceptors(advisor, interceptorFactory, interceptorsAnnotation.value(), classInterceptors, interceptors, lifeCycleInterceptors);
            }
            log.debug((Object)("Found class interceptors " + classInterceptors));
            instanceAdvisor.getMetaData().addMetaData(InterceptorsFactory.class, (Object)"classInterceptors", classInterceptors);
            Class beanClass = advisor.getClazz();
            ArrayList<BusinessMethodBeanMethodInterceptor> beanInterceptors = new ArrayList<BusinessMethodBeanMethodInterceptor>();
            for (Method beanMethod : ClassHelper.getAllMethods(beanClass)) {
                interceptorsAnnotation = (Interceptors)advisor.resolveAnnotation(beanMethod, Interceptors.class);
                if (interceptorsAnnotation != null) {
                    ArrayList<BusinessMethodInterceptorMethodInterceptor> businessMethodInterceptors = new ArrayList<BusinessMethodInterceptorMethodInterceptor>();
                    for (Class interceptorClass : interceptorsAnnotation.value()) {
                        Object interceptor = interceptors.get(interceptorClass);
                        if (interceptor == null) {
                            interceptor = interceptorFactory.create(advisor, interceptorClass);
                            interceptors.put(interceptorClass, interceptor);
                        }
                        ExtendedAdvisor interceptorAdvisor = ExtendedAdvisorHelper.getExtendedAdvisor(advisor, interceptor);
                        for (Method method : ClassHelper.getAllMethods(interceptorClass)) {
                            if (!interceptorAdvisor.isAnnotationPresent(interceptorClass, method, AroundInvoke.class)) continue;
                            businessMethodInterceptors.add(new BusinessMethodInterceptorMethodInterceptor(interceptor, method));
                        }
                    }
                    instanceAdvisor.getMetaData().addMetaData(InterceptorsFactory.class, (Object)beanMethod, businessMethodInterceptors);
                }
                if (advisor.hasAnnotation(beanMethod, AroundInvoke.class)) {
                    beanInterceptors.add(new BusinessMethodBeanMethodInterceptor(beanMethod));
                }
                for (Class<? extends Annotation> lifeCycleAnnotationClass : lifeCycleAnnotationClasses) {
                    if (!advisor.hasAnnotation(beanMethod, lifeCycleAnnotationClass)) continue;
                    ((List)lifeCycleInterceptors.get(lifeCycleAnnotationClass)).add(new LifecycleCallbackBeanMethodInterceptor(beanMethod));
                }
            }
            log.debug((Object)("Found bean interceptors " + beanInterceptors));
            instanceAdvisor.getMetaData().addMetaData(InterceptorsFactory.class, (Object)"beanInterceptors", beanInterceptors);
            log.debug((Object)("Found life cycle interceptors " + lifeCycleInterceptors));
            instanceAdvisor.getMetaData().addMetaData(InterceptorsFactory.class, (Object)"lifeCycleInterceptors", Collections.unmodifiableMap(lifeCycleInterceptors));
            return new NopInterceptor();
        }
        catch (InstantiationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Interceptor> getBeanInterceptors(InstanceAdvisor instanceAdvisor) {
        return (List)instanceAdvisor.getMetaData().getMetaData(InterceptorsFactory.class, (Object)"beanInterceptors");
    }

    @Deprecated
    public static Interceptor[] getBusinessMethodInterceptors(MethodInvocation invocation) {
        List list = (List)invocation.getMetaData(InterceptorsFactory.class, (Object)invocation.getActualMethod());
        if (list == null) {
            return null;
        }
        return list.toArray(new Interceptor[0]);
    }

    public static List<Interceptor> getBusinessMethodInterceptors(InstanceAdvisor instanceAdvisor, Method businessMethod) {
        return (List)instanceAdvisor.getMetaData().getMetaData(InterceptorsFactory.class, (Object)businessMethod);
    }

    @Deprecated
    public static Interceptor[] getClassInterceptors(Invocation invocation) {
        return ((List)invocation.getMetaData(InterceptorsFactory.class, (Object)"classInterceptors")).toArray(new Interceptor[0]);
    }

    public static List<Interceptor> getClassInterceptors(InstanceAdvisor instanceAdvisor) {
        return (List)instanceAdvisor.getMetaData().getMetaData(InterceptorsFactory.class, (Object)"classInterceptors");
    }

    public static List<Interceptor> getDefaultInterceptors(InstanceAdvisor instanceAdvisor) {
        return (List)instanceAdvisor.getMetaData().getMetaData(InterceptorsFactory.class, (Object)"defaultInterceptors");
    }

    private static Map<Class<? extends Annotation>, List<Interceptor>> getLifeCycleInterceptors(InstanceAdvisor instanceAdvisor) {
        return (Map)instanceAdvisor.getMetaData().getMetaData(InterceptorsFactory.class, (Object)"lifeCycleInterceptors");
    }

    public static List<Interceptor> getLifeCycleInterceptors(InstanceAdvisor instanceAdvisor, Class<? extends Annotation> lifeCycleAnnotationClass) {
        return InterceptorsFactory.getLifeCycleInterceptors(instanceAdvisor).get(lifeCycleAnnotationClass);
    }

    @Deprecated
    public static List<Interceptor> getPreDestroys(InstanceAdvisor instanceAdvisor) {
        return InterceptorsFactory.getLifeCycleInterceptors(instanceAdvisor, PreDestroy.class);
    }

    private String toString(Object obj) {
        return obj.getClass().getName() + "@" + System.identityHashCode(obj);
    }
}

