/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.jacorb.transaction.CoordinatorImpl;
import org.jacorb.transaction.Timer;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.TransactionFactoryPOA;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import org.slf4j.Logger;

public class TransactionService
extends TransactionFactoryPOA {
    private static boolean initialized = false;
    private static TransactionService factory;
    private static TransactionFactory fact_ref;
    private static CoordinatorImpl[] coordinators;
    private static Timer timer;
    private static int trans_id;
    private static POA poa;
    private static Logger logger;

    static Timer get_timer() {
        return timer;
    }

    public static boolean is_initialized() {
        return initialized;
    }

    public static TransactionFactory get_reference() {
        return fact_ref;
    }

    static void release_coordinator(int n) {
        TransactionService.coordinators[n] = null;
    }

    private int find_free() {
        for (int i = 0; i < coordinators.length; ++i) {
            if (coordinators[i] != null) continue;
            return i;
        }
        throw new INTERNAL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Control create(int n) {
        ++trans_id;
        CoordinatorImpl[] coordinatorImplArray = coordinators;
        synchronized (coordinators) {
            int n2 = this.find_free();
            TransactionService.coordinators[n2] = new CoordinatorImpl(poa, trans_id, n2, n);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return coordinators[n2]._get_control();
        }
    }

    public Control recreate(PropagationContext propagationContext) {
        throw new NO_IMPLEMENT();
    }

    public static void start(POA pOA, int n) {
        if (initialized) {
            throw new INTERNAL();
        }
        try {
            poa = pOA;
            factory = new TransactionService();
            fact_ref = TransactionFactoryHelper.narrow((Object)poa.servant_to_reference((Servant)((java.lang.Object)factory)));
            coordinators = new CoordinatorImpl[n];
            for (int i = 0; i < coordinators.length; ++i) {
                TransactionService.coordinators[i] = null;
            }
            timer = new Timer(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        initialized = true;
    }

    public static void main(String[] stringArray) {
        ORB oRB = ORB.init(stringArray, null);
        logger = ((org.jacorb.orb.ORB)oRB).getConfiguration().getLogger("jacorb.tx_service");
        try {
            POA pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            TransactionService transactionService = new TransactionService();
            TransactionService.start(pOA, 10);
            if (stringArray.length == 1) {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(stringArray[0])));
                printWriter.println(oRB.object_to_string((Object)transactionService.get_reference()));
                printWriter.close();
            } else {
                NamingContextExt namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
                NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("TransactionService", "service")};
                namingContextExt.bind(nameComponentArray, (Object)transactionService.get_reference());
            }
            if (logger.isInfoEnabled()) {
                logger.info("TransactionService up");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        oRB.run();
    }

    static {
        trans_id = 0;
    }
}

