/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.vfs.VFSResourceVisitor;
import org.jboss.classloading.plugins.visitor.FederatedResourceVisitor;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.scanning.plugins.SecurityActions;
import org.jboss.scanning.plugins.VFSUrlScanner;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScanner
extends VFSUrlScanner {
    private ClassLoader classLoader;
    private Map<ScanningPlugin, ScanningHandle> handles;
    protected VirtualFile[] excludedRoots;
    protected ClassFilter included;
    protected ClassFilter excluded;

    public DefaultScanner(ClassLoader classLoader, URL ... roots) {
        super(roots);
        this.classLoader = classLoader;
        this.handles = new HashMap<ScanningPlugin, ScanningHandle>();
        this.setToVFS(true);
    }

    public Map<ScanningPlugin, ScanningHandle> getHandles() {
        return this.handles;
    }

    public boolean doScan() {
        return this.getRoots().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(Set<ScanningPlugin> plugins) throws Exception {
        URL[] urls = this.isToVFS() ? DefaultScanner.toVFS(this.getRoots()) : this.getRoots();
        VirtualFile[] roots = new VirtualFile[urls.length];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = VFS.getChild((URL)urls[i]);
        }
        ScanningPlugin[] array = plugins.toArray(new ScanningPlugin[plugins.size()]);
        FederatedResourceVisitor visitor = new FederatedResourceVisitor((ResourceVisitor[])array, (ResourceFilter[])array, this.getRecurseFilters(array));
        ResourceFilter filter = visitor.getFilter();
        ResourceFilter recurseFilter = visitor.getRecurseFilter();
        ClassLoader tccl = SecurityActions.setContextClassLoader(this.classLoader);
        try {
            VFSResourceVisitor.visit((VirtualFile[])roots, (VirtualFile[])this.excludedRoots, (ClassFilter)this.included, (ClassFilter)this.excluded, (ClassLoader)this.classLoader, (ResourceVisitor)visitor, (ResourceFilter)filter, (ResourceFilter)recurseFilter, (URL[])urls);
        }
        finally {
            SecurityActions.resetContextClassLoader(tccl);
        }
    }

    protected ScanningHandle createHandle(ScanningPlugin plugin) {
        ScanningHandle handle = plugin.createHandle();
        this.handles.put(plugin, handle);
        return handle;
    }

    public void setExcludedRoots(VirtualFile[] excludedRoots) {
        this.excludedRoots = excludedRoots;
    }

    public void setIncluded(ClassFilter included) {
        this.included = included;
    }

    public void setExcluded(ClassFilter excluded) {
        this.excluded = excluded;
    }
}

