/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jacorb.config.Configuration;
import org.jboss.iiop.CorbaNamingServiceMBean;
import org.jboss.iiop.CorbaORBService;
import org.jboss.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaNamingService
implements CorbaNamingServiceMBean,
ObjectFactory {
    public static String NAMING_NAME = "JBossCorbaNaming";
    private POA namingPOA;
    private static NamingContextExt namingService;
    private static Logger log;

    @Override
    public String list() {
        StringBuffer buf = new StringBuffer();
        CorbaNamingService.rlist((NamingContext)namingService, new NameComponent[0], buf);
        return buf.toString();
    }

    public void start() throws Exception {
        POA rootPOA;
        ORB orb;
        InitialContext ctx;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException("Cannot get intial JNDI context: " + e);
        }
        try {
            orb = (ORB)ctx.lookup("java:/" + CorbaORBService.ORB_NAME);
        }
        catch (NamingException e) {
            throw new RuntimeException("Cannot lookup java:/" + CorbaORBService.ORB_NAME + ": " + e);
        }
        try {
            rootPOA = (POA)ctx.lookup("java:/" + CorbaORBService.POA_NAME);
        }
        catch (NamingException e) {
            throw new RuntimeException("Cannot lookup java:/" + CorbaORBService.POA_NAME + ": " + e);
        }
        Policy[] policies = new Policy[]{rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
        this.namingPOA = rootPOA.create_POA("Naming", null, policies);
        this.namingPOA.the_POAManager().activate();
        org.jacorb.naming.NamingContextImpl.init((ORB)orb, (POA)rootPOA);
        NamingContextImpl ns = new NamingContextImpl(this.namingPOA);
        Configuration config = ((org.jacorb.orb.ORB)orb).getConfiguration();
        ns.configure(config);
        byte[] rootContextId = "root".getBytes();
        this.namingPOA.activate_object_with_id(rootContextId, (Servant)ns);
        namingService = NamingContextExtHelper.narrow((Object)this.namingPOA.create_reference_with_id(rootContextId, "IDL:omg.org/CosNaming/NamingContextExt:1.0"));
        this.bind(NAMING_NAME, "org.omg.CosNaming.NamingContextExt");
        log.info((java.lang.Object)"CORBA Naming Started");
        log.debug((java.lang.Object)("Naming: [" + orb.object_to_string((Object)namingService) + "]"));
    }

    public void stop() {
        try {
            this.unbind(NAMING_NAME);
        }
        catch (Exception e) {
            log.error((java.lang.Object)"Exception while stopping CORBA naming service", (Throwable)e);
        }
        try {
            this.namingPOA.destroy(false, false);
        }
        catch (Exception e) {
            log.error((java.lang.Object)"Exception while stopping CORBA naming service", (Throwable)e);
        }
    }

    @Override
    public java.lang.Object getObjectInstance(java.lang.Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        String s = name.toString();
        if (log.isTraceEnabled()) {
            log.trace((java.lang.Object)("getObjectInstance: obj.getClass().getName=\"" + obj.getClass().getName() + "\n                   name=" + s));
        }
        if (NAMING_NAME.equals(s)) {
            return namingService;
        }
        return null;
    }

    private void bind(String name, String className) throws Exception {
        Reference ref = new Reference(className, this.getClass().getName(), null);
        new InitialContext().bind("java:/" + name, (java.lang.Object)ref);
    }

    private void unbind(String name) throws Exception {
        new InitialContext().unbind("java:/" + name);
    }

    private static void rlist(NamingContext ctx, NameComponent[] base, StringBuffer buf) {
        BindingListHolder listHolder = new BindingListHolder(new Binding[0]);
        BindingIteratorHolder iterHolder = new BindingIteratorHolder();
        ctx.list(0, listHolder, iterHolder);
        BindingHolder bindingHolder = new BindingHolder();
        if (iterHolder.value == null) {
            return;
        }
        NameComponent[] name = new NameComponent[base.length + 1];
        for (int i = 0; i < base.length; ++i) {
            name[i] = base[i];
        }
        while (iterHolder.value.next_one(bindingHolder)) {
            Binding binding = bindingHolder.value;
            name[name.length - 1] = binding.binding_name[0];
            try {
                String stringName = namingService.to_string(name);
                buf.append(stringName);
            }
            catch (Exception e) {
                buf.append(e.getMessage());
            }
            if (binding.binding_type.value() == 1) {
                buf.append('/');
                buf.append('\n');
                try {
                    NamingContext subCtx = NamingContextHelper.narrow((Object)ctx.resolve(binding.binding_name));
                    CorbaNamingService.rlist(subCtx, name, buf);
                }
                catch (Exception e) {
                    buf.append(e.getMessage());
                }
                continue;
            }
            buf.append('\n');
        }
    }

    static {
        log = Logger.getLogger(CorbaNamingService.class);
    }

    static class NamingContextImpl
    extends org.jacorb.naming.NamingContextImpl {
        private POA poa;
        private int childCount = 0;
        private static final Logger logger = Logger.getLogger(NamingContextImpl.class);

        NamingContextImpl(POA poa) {
            this.poa = poa;
        }

        public NamingContext new_context() {
            try {
                NamingContextImpl newContextImpl = new NamingContextImpl(this.poa);
                byte[] oid = (new String(this.poa.servant_to_id((Servant)this)) + "/ctx" + ++this.childCount).getBytes();
                this.poa.activate_object_with_id(oid, (Servant)newContextImpl);
                return NamingContextExtHelper.narrow((Object)this.poa.create_reference_with_id(oid, "IDL:omg.org/CosNaming/NamingContextExt:1.0"));
            }
            catch (Exception e) {
                logger.error((java.lang.Object)"Cannot create CORBA naming context", (Throwable)e);
                return null;
            }
        }
    }
}

