/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.plugins.jbossas5.adapter.api.MeasurementAdapter;
import org.rhq.plugins.jbossas5.adapter.api.MeasurementAdapterFactory;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapterFactory;
import org.rhq.plugins.jbossas5.util.MetaTypeUtils;
import org.rhq.plugins.jbossas5.util.ResourceTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionUtils {
    private static final Log LOG = LogFactory.getLog(ConversionUtils.class);
    private static final Map<String, ComponentType> COMPONENT_TYPE_CACHE = new HashMap<String, ComponentType>();
    private static final Map<String, KnownDeploymentTypes> DEPLOYMENT_TYPE_CACHE = new HashMap<String, KnownDeploymentTypes>();
    private static final Map<String, Configuration> DEFAULT_PLUGIN_CONFIG_CACHE = new HashMap<String, Configuration>();
    protected static final String PLUGIN = "ProfileService";

    public static ComponentType getComponentType(@NotNull ResourceType resourceType) {
        String resourceTypeName = resourceType.getName();
        if (COMPONENT_TYPE_CACHE.containsKey(resourceTypeName)) {
            return COMPONENT_TYPE_CACHE.get(resourceTypeName);
        }
        Configuration defaultPluginConfig = ConversionUtils.getDefaultPluginConfiguration(resourceType);
        String type = defaultPluginConfig.getSimpleValue("componentType", null);
        if (type == null || type.equals("")) {
            throw new IllegalStateException("Required plugin configuration property 'componentType' is not defined in default template.");
        }
        String subtype = defaultPluginConfig.getSimpleValue("componentSubtype", null);
        if (subtype == null || subtype.equals("")) {
            throw new IllegalStateException("Required plugin configuration property 'componentSubtype' is not defined in default template.");
        }
        ComponentType componentType = new ComponentType(type, subtype);
        COMPONENT_TYPE_CACHE.put(resourceTypeName, componentType);
        return componentType;
    }

    public static KnownDeploymentTypes getDeploymentType(@NotNull ResourceType resourceType) {
        String resourceTypeName = resourceType.getName();
        if (DEPLOYMENT_TYPE_CACHE.containsKey(resourceTypeName)) {
            return DEPLOYMENT_TYPE_CACHE.get(resourceTypeName);
        }
        Configuration defaultPluginConfig = ConversionUtils.getDefaultPluginConfiguration(resourceType);
        String typeName = defaultPluginConfig.getSimpleValue("deploymentTypeName", null);
        if (typeName == null || typeName.equals("")) {
            throw new IllegalStateException("Required plugin configuration property 'componentType' is not defined in default template.");
        }
        KnownDeploymentTypes deploymentType = KnownDeploymentTypes.valueOf((String)typeName);
        DEPLOYMENT_TYPE_CACHE.put(resourceTypeName, deploymentType);
        return deploymentType;
    }

    public static Configuration convertManagedObjectToConfiguration(Map<String, ManagedProperty> managedProperties, Map<String, PropertySimple> customProps, ResourceType resourceType) {
        Configuration config = new Configuration();
        ConfigurationDefinition configDef = resourceType.getResourceConfigurationDefinition();
        Map propDefs = configDef.getPropertyDefinitions();
        Set<String> propNames = managedProperties.keySet();
        for (String propName : propNames) {
            Object property;
            PropertyDefinition propertyDefinition = (PropertyDefinition)propDefs.get(propName);
            ManagedProperty managedProperty = managedProperties.get(propName);
            if (propertyDefinition == null) {
                if (managedProperty.hasViewUse(ViewUse.STATISTIC)) continue;
                LOG.debug((Object)(resourceType + " does not define a property corresponding to ManagedProperty '" + propName + "'."));
                continue;
            }
            if (managedProperty == null) {
                LOG.error((Object)("ManagedProperty '" + propName + "' has a null value in the ManagedProperties Map."));
                continue;
            }
            MetaValue metaValue = managedProperty.getValue();
            if (managedProperty.isRemoved() || metaValue == null) continue;
            PropertySimple customProp = customProps.get(propName);
            PropertyAdapter propertyAdapter = PropertyAdapterFactory.getCustomPropertyAdapter(customProp);
            if (propertyAdapter == null) {
                propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(metaValue);
            }
            if (propertyAdapter == null) {
                LOG.error((Object)("Unable to find a PropertyAdapter for ManagedProperty '" + propName + "' with MetaType [" + metaValue.getMetaType() + "] for ResourceType '" + resourceType.getName() + "'."));
                continue;
            }
            try {
                property = propertyAdapter.convertToProperty(metaValue, propertyDefinition);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed to convert managed property " + managedProperty + " to RHQ property of type " + propertyDefinition + ".", e);
            }
            config.put(property);
        }
        return config;
    }

    public static void convertConfigurationToManagedProperties(Map<String, ManagedProperty> managedProperties, Configuration configuration, ResourceType resourceType, Map<String, PropertySimple> customProps) {
        ConfigurationDefinition configDefinition = resourceType.getResourceConfigurationDefinition();
        HashSet<String> missingManagedPropertyNames = new HashSet<String>();
        for (Property property : configuration.getProperties()) {
            String propertyName = property.getName();
            ManagedProperty managedProperty = managedProperties.get(propertyName);
            PropertyDefinition propertyDefinition = configDefinition.get(propertyName);
            if (managedProperty == null) {
                missingManagedPropertyNames.add(propertyName);
            } else {
                ConversionUtils.populateManagedPropertyFromProperty(property, propertyDefinition, managedProperty, customProps.get(propertyName));
            }
            if (missingManagedPropertyNames.isEmpty()) continue;
            throw new IllegalStateException("***** The following properties are defined in this plugin's descriptor but have no coresponding ManagedProperties: " + missingManagedPropertyNames);
        }
    }

    private static Configuration getDefaultPluginConfiguration(ResourceType resourceType) {
        Configuration defaultPluginConfig;
        if (DEFAULT_PLUGIN_CONFIG_CACHE.containsKey(resourceType.getName())) {
            defaultPluginConfig = DEFAULT_PLUGIN_CONFIG_CACHE.get(resourceType.getName());
        } else {
            defaultPluginConfig = ResourceTypeUtils.getDefaultPluginConfiguration(resourceType);
            DEFAULT_PLUGIN_CONFIG_CACHE.put(resourceType.getName(), defaultPluginConfig);
        }
        return defaultPluginConfig;
    }

    private static void populateManagedPropertyFromProperty(Property property, PropertyDefinition propertyDefinition, @NotNull ManagedProperty managedProperty, @Nullable PropertySimple customProperty) {
        MetaValue defaultValue;
        if (property == null || property instanceof PropertySimple && ((PropertySimple)property).getStringValue() == null) {
            managedProperty.setRemoved(true);
        }
        if ((defaultValue = managedProperty.getDefaultValue()) != null) {
            ConversionUtils.updateDefaultValueOnPropertyDefinition(propertyDefinition, defaultValue);
        }
        PropertyAdapter propertyAdapter = PropertyAdapterFactory.getCustomPropertyAdapter(customProperty);
        MetaValue metaValue = managedProperty.getValue();
        if (metaValue != null) {
            LOG.trace((Object)("Populating existing MetaValue of type " + metaValue.getMetaType() + " from RHQ property " + property + " with definition " + propertyDefinition + "..."));
            if (propertyAdapter == null) {
                propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(metaValue);
            }
            propertyAdapter.populateMetaValueFromProperty(property, metaValue, propertyDefinition);
        } else {
            MetaType metaType = managedProperty.getMetaType();
            if (propertyAdapter == null) {
                propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(metaType);
            }
            LOG.trace((Object)("Converting property " + property + " with definition " + propertyDefinition + " to MetaValue of type " + metaType + "..."));
            metaValue = propertyAdapter.convertToMetaValue(property, propertyDefinition, metaType);
            managedProperty.setValue(metaValue);
        }
    }

    private static void updateDefaultValueOnPropertyDefinition(PropertyDefinition propertyDefinition, @NotNull MetaValue defaultValue) {
        if (!(propertyDefinition instanceof PropertyDefinitionSimple)) {
            LOG.debug((Object)("Cannot update default value on non-simple property definition " + propertyDefinition + "(default value is " + defaultValue + ")."));
            return;
        }
        MetaType metaType = defaultValue.getMetaType();
        if (!metaType.isSimple() && !metaType.isEnum()) {
            LOG.debug((Object)("Cannot update default value on " + propertyDefinition + ", because default value's type (" + metaType + ") is not simple or enum."));
            return;
        }
        PropertyDefinitionSimple propertyDefinitionSimple = (PropertyDefinitionSimple)propertyDefinition;
        if (metaType.isSimple()) {
            SimpleValue defaultSimpleValue = (SimpleValue)defaultValue;
            Serializable value = defaultSimpleValue.getValue();
            propertyDefinitionSimple.setDefaultValue(value != null ? value.toString() : null);
        } else {
            EnumValue defaultEnumValue = (EnumValue)defaultValue;
            String value = defaultEnumValue.getValue();
            propertyDefinitionSimple.setDefaultValue(value != null ? value.toString() : null);
        }
    }

    public static MetaType convertPropertyDefinitionToMetaType(PropertyDefinition propDef) {
        MetaType memberMetaType;
        if (propDef instanceof PropertyDefinitionSimple) {
            PropertySimpleType propSimpleType = ((PropertyDefinitionSimple)propDef).getType();
            memberMetaType = ConversionUtils.convertPropertySimpleTypeToSimpleMetaType(propSimpleType);
        } else if (propDef instanceof PropertyDefinitionList) {
            memberMetaType = null;
        } else if (propDef instanceof PropertyDefinitionMap) {
            Map memberPropDefs = ((PropertyDefinitionMap)propDef).getPropertyDefinitions();
            if (memberPropDefs.isEmpty()) {
                throw new IllegalStateException("PropertyDefinitionMap doesn't contain any member PropertyDefinitions.");
            }
            PropertyDefinition mapMemberPropDef = (PropertyDefinition)memberPropDefs.values().iterator().next();
            MetaType mapMemberMetaType = ConversionUtils.convertPropertyDefinitionToMetaType(mapMemberPropDef);
            memberMetaType = new MapCompositeMetaType(mapMemberMetaType);
        } else {
            throw new IllegalStateException("List member PropertyDefinition has unknown type: " + propDef.getClass().getName());
        }
        return memberMetaType;
    }

    private static MetaType convertPropertySimpleTypeToSimpleMetaType(PropertySimpleType memberSimpleType) {
        Class memberClass;
        switch (memberSimpleType) {
            case BOOLEAN: {
                memberClass = Boolean.class;
                break;
            }
            case INTEGER: {
                memberClass = Integer.class;
                break;
            }
            case LONG: {
                memberClass = Long.class;
                break;
            }
            case FLOAT: {
                memberClass = Float.class;
                break;
            }
            case DOUBLE: {
                memberClass = Double.class;
                break;
            }
            default: {
                memberClass = String.class;
            }
        }
        SimpleMetaType memberMetaType = SimpleMetaType.resolve((String)memberClass.getName());
        return memberMetaType;
    }

    @NotNull
    public static MetaValue[] convertOperationsParametersToMetaValues(@NotNull ManagedOperation managedOperation, @NotNull Configuration parameters, @NotNull OperationDefinition operationDefinition) {
        ConfigurationDefinition paramsConfigDef = operationDefinition.getParametersConfigurationDefinition();
        if (paramsConfigDef == null) {
            return new MetaValue[0];
        }
        ManagedParameter[] managedParams = managedOperation.getParameters();
        Map paramPropDefs = paramsConfigDef.getPropertyDefinitions();
        MetaValue[] paramMetaValues = new MetaValue[managedParams.length];
        for (int i = 0; i < managedParams.length; ++i) {
            MetaValue paramMetaValue;
            ManagedParameter managedParam = managedParams[i];
            String paramName = managedParam.getName();
            Property paramProp = parameters.get(paramName);
            PropertyDefinition paramPropDef = (PropertyDefinition)paramPropDefs.get(paramName);
            MetaType metaType = managedParam.getMetaType();
            PropertyAdapter propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(metaType);
            LOG.trace((Object)("Converting RHQ operation param property " + paramProp + " with definition " + paramPropDef + " to MetaValue of type " + metaType + "..."));
            paramMetaValues[i] = paramMetaValue = propertyAdapter.convertToMetaValue(paramProp, paramPropDef, metaType);
        }
        return paramMetaValues;
    }

    public static void convertManagedOperationResults(ManagedOperation operation, MetaValue resultMetaValue, Configuration complexResults, OperationDefinition operationDefinition) {
        ConfigurationDefinition resultConfigDef = operationDefinition.getResultsConfigurationDefinition();
        if (resultConfigDef == null || resultConfigDef.getPropertyDefinitions().isEmpty()) {
            if (resultMetaValue != null) {
                LOG.error((Object)("Plugin error: Operation [" + operationDefinition.getName() + "] is defined as returning no results, but it returned non-null results: " + resultMetaValue.toString()));
            }
            return;
        }
        Map resultPropDefs = resultConfigDef.getPropertyDefinitions();
        if (resultPropDefs.size() > 1) {
            LOG.error((Object)("Operation [" + operationDefinition.getName() + "] is defined with multiple result properties: " + resultPropDefs.values()));
        }
        PropertyDefinition resultPropDef = (PropertyDefinition)resultPropDefs.values().iterator().next();
        if (resultMetaValue == null) {
            if (resultPropDef.isRequired()) {
                LOG.error((Object)("Plugin error: Operation [" + operationDefinition.getName() + "] is defined as returning a required result, but it returned null."));
            }
            return;
        }
        MetaType resultMetaType = operation.getReturnType();
        if (!MetaTypeUtils.instanceOf(resultMetaValue, resultMetaType)) {
            LOG.debug((Object)("Profile Service Error: Result type (" + resultMetaType + ") of [" + operation.getName() + "] ManagedOperation does not match the type of the value returned by invoke() (" + resultMetaValue + ")."));
        }
        PropertyAdapter propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(resultMetaValue);
        Object resultProp = propertyAdapter.convertToProperty(resultMetaValue, resultPropDef);
        complexResults.put(resultProp);
    }

    public static void convertMetricValuesToMeasurement(MeasurementReport report, ManagedProperty metricProperty, MeasurementScheduleRequest request, ResourceType resourceType, String deploymentName) {
        String metricName = metricProperty.getName();
        MetaType type = metricProperty.getMetaType();
        MetaValue value = metricProperty.getValue();
        if (value != null) {
            MeasurementAdapter measurementAdapter = MeasurementAdapterFactory.getMeasurementPropertyAdapter(type);
            MeasurementDefinition measurementDefinition = ResourceTypeUtils.getMeasurementDefinition(resourceType, metricName);
            if (measurementDefinition != null) {
                measurementAdapter.setMeasurementData(report, value, request, measurementDefinition);
            }
        } else {
            LOG.debug((Object)("Unable to obtain metric data for resource: " + deploymentName + " metric: " + metricName));
        }
    }
}

