/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.plugins.jbossas5.ManagedComponentComponent;
import org.rhq.plugins.jbossas5.helper.MoreKnownComponentTypes;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorComponent
extends ManagedComponentComponent {
    static final String PROTOCOL_PROPERTY = "protocol";
    static final String ADDRESS_PROPERTY = "address";
    static final String PORT_PROPERTY = "port";
    private static final String THREAD_POOL_METRIC_PREFIX = "ThreadPool|";
    private static final String WEB_THREAD_POOL_COMPONENT_NAME_TEMPLATE = "jboss.web:name=%protocol%-%address%-%port%,type=ThreadPool";
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        LinkedHashSet<MeasurementScheduleRequest> remainingRequests = new LinkedHashSet<MeasurementScheduleRequest>();
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        String webThreadPoolComponentName = ResourceComponentUtils.replacePropertyExpressionsInTemplate(WEB_THREAD_POOL_COMPONENT_NAME_TEMPLATE, pluginConfig);
        ComponentType webThreadPoolComponentType = MoreKnownComponentTypes.MBean.WebThreadPool.getType();
        ManagementView managementView = this.getConnection().getManagementView();
        ManagedComponent webThreadPoolComponent = managementView.getComponent(webThreadPoolComponentName, webThreadPoolComponentType);
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            try {
                if (metricName.startsWith(THREAD_POOL_METRIC_PREFIX)) {
                    Object value = this.getSimpleValue(webThreadPoolComponent, request);
                    this.addValueToMeasurementReport(report, request, value);
                    continue;
                }
                remainingRequests.add(request);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to collect metric '" + metricName + "' for " + this.getResourceContext().getResourceType() + " Resource with key " + this.getResourceContext().getResourceKey() + "."), (Throwable)e);
            }
        }
        super.getValues(report, remainingRequests);
    }
}

