/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.net.InetAddress;
import javax.management.MBeanServer;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.RequestHandler;
import org.jboss.logging.Logger;
import org.opennms.protocols.snmp.SnmpAgentSession;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public class RequestHandlerSupport
implements RequestHandler {
    protected Logger log;
    protected MBeanServer server;
    protected String resourceName;
    protected Clock clock;

    public void initialize(String resourceName, MBeanServer server, Logger log, Clock uptime) throws Exception {
        this.resourceName = resourceName;
        this.server = server;
        this.log = log;
        this.clock = uptime;
    }

    public SnmpPduRequest snmpReceivedGet(SnmpPduPacket pdu, boolean getNext) {
        SnmpPduRequest response = null;
        int pduLength = pdu.getLength();
        this.log.debug((Object)("requestId=" + pdu.getRequestId() + ", pduLength=" + pduLength));
        SnmpVarBind[] vblist = new SnmpVarBind[pduLength];
        int errorStatus = 0;
        int errorIndex = 0;
        for (int i = 0; i < pduLength; ++i) {
            SnmpVarBind vb = pdu.getVarBindAt(i);
            SnmpObjectId oid = vb.getName();
            if (getNext) {
                this.log.debug((Object)"Should call getNextOid() to find out what is the next valid OID instance in the supported MIB tree. Assign that OID to the VB List and then proceed same as that of get request");
            }
            vblist[i] = new SnmpVarBind(oid);
            this.log.debug((Object)("oid=" + oid.toString()));
            this.log.debug((Object)"Should call the respective interface to retrieve current value for this OID");
            SnmpSyntax result = null;
            if (result == null) {
                errorStatus = 2;
                errorIndex = i + 1;
                continue;
            }
            vblist[i].setValue(result);
            this.log.debug((Object)("Varbind[" + i + "] := " + vblist[i].getName().toString()));
            this.log.debug((Object)(" --> " + vblist[i].getValue().toString()));
        }
        response = new SnmpPduRequest(162, vblist);
        response.setErrorStatus(errorStatus);
        response.setErrorIndex(errorIndex);
        return response;
    }

    public SnmpPduRequest snmpReceivedSet(SnmpPduPacket pdu) {
        SnmpPduRequest response = null;
        int errorStatus = 0;
        int errorIndex = 0;
        int k = pdu.getLength();
        SnmpVarBind[] vblist = new SnmpVarBind[k];
        for (int i = 0; i < k; ++i) {
            SnmpVarBind vb = pdu.getVarBindAt(i);
            vblist[i] = new SnmpVarBind(vb);
            SnmpObjectId oid = vb.getName();
            Object result = null;
            this.log.debug((Object)"Should call the respective interface to assign a value for this OID");
            if (result != null) {
                errorStatus = 4;
                errorIndex = i + 1;
                this.log.debug((Object)("Error occured " + vb.getName().toString()));
            }
            this.log.debug((Object)("Varbind[" + i + "] := " + vb.getName().toString()));
            this.log.debug((Object)(" --> " + vb.getValue().toString()));
        }
        response = new SnmpPduRequest(162, vblist);
        response.setErrorStatus(errorStatus);
        response.setErrorIndex(errorIndex);
        return response;
    }

    public void snmpReceivedPdu(SnmpAgentSession session, InetAddress manager, int port, SnmpOctetString community, SnmpPduPacket pdu) {
        this.log.error((Object)("Message from manager " + manager.toString() + " on port " + port));
        int cmd = pdu.getCommand();
        this.log.error((Object)("Unsupported PDU command......... " + cmd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SnmpAgentSessionError(SnmpAgentSession session, int error, Object ref) {
        this.log.error((Object)"An error occured in the trap session");
        this.log.error((Object)("Session error code = " + error));
        if (ref != null) {
            this.log.error((Object)("Session error reference: " + ref.toString()));
        }
        if (error == -1) {
            SnmpAgentSession snmpAgentSession = session;
            synchronized (snmpAgentSession) {
                session.notify();
            }
        }
    }
}

