/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.interfaces;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.ha.framework.interfaces.FamilyClusterInfoImpl;

public class ClusteringTargetsRepository {
    private static ConcurrentMap<String, FamilyClusterInfo> families = new ConcurrentHashMap<String, FamilyClusterInfo>();

    public static FamilyClusterInfo initTarget(String familyName, List targets) {
        return ClusteringTargetsRepository.initTarget(familyName, targets, 0L);
    }

    public static FamilyClusterInfo initTarget(String familyName, List targets, long viewId) {
        FamilyClusterInfoImpl family;
        FamilyClusterInfo existing = (FamilyClusterInfo)families.get(familyName);
        if (existing == null && (existing = families.putIfAbsent(familyName, family = new FamilyClusterInfoImpl(familyName, targets, viewId))) == null) {
            return family;
        }
        existing.updateClusterInfo(targets, viewId);
        return existing;
    }

    public static FamilyClusterInfo getFamilyClusterInfo(String familyName) {
        return (FamilyClusterInfo)families.get(familyName);
    }

    private ClusteringTargetsRepository() {
    }
}

