/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRAManagedConnection;

public class HornetQRAXAResource
implements XAResource {
    private static final Logger log = Logger.getLogger(HornetQRAXAResource.class);
    private static boolean trace = log.isTraceEnabled();
    private final HornetQRAManagedConnection managedConnection;
    private final XAResource xaResource;

    public HornetQRAXAResource(HornetQRAManagedConnection managedConnection, XAResource xaResource) {
        if (trace) {
            log.trace((Object)("constructor(" + managedConnection + ", " + xaResource + ")"));
        }
        this.managedConnection = managedConnection;
        this.xaResource = xaResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (trace) {
            log.trace((Object)("start(" + xid + ", " + flags + ")"));
        }
        this.managedConnection.lock();
        try {
            this.xaResource.start(xid, flags);
        }
        finally {
            this.managedConnection.setInManagedTx(true);
            this.managedConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (trace) {
            log.trace((Object)("end(" + xid + ", " + flags + ")"));
        }
        this.managedConnection.lock();
        try {
            this.xaResource.end(xid, flags);
        }
        finally {
            this.managedConnection.setInManagedTx(false);
            this.managedConnection.unlock();
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("prepare(" + xid + ")"));
        }
        return this.xaResource.prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (trace) {
            log.trace((Object)("commit(" + xid + ", " + onePhase + ")"));
        }
        this.xaResource.commit(xid, onePhase);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("rollback(" + xid + ")"));
        }
        this.xaResource.rollback(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("forget(" + xid + ")"));
        }
        this.managedConnection.lock();
        try {
            this.xaResource.forget(xid);
        }
        finally {
            this.managedConnection.setInManagedTx(true);
            this.managedConnection.setInManagedTx(false);
            this.managedConnection.unlock();
        }
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (trace) {
            log.trace((Object)("isSameRM(" + xaRes + ")"));
        }
        return this.xaResource.isSameRM(xaRes);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (trace) {
            log.trace((Object)("recover(" + flag + ")"));
        }
        return this.xaResource.recover(flag);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (trace) {
            log.trace((Object)"getTransactionTimeout()");
        }
        return this.xaResource.getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (trace) {
            log.trace((Object)("setTransactionTimeout(" + seconds + ")"));
        }
        return this.xaResource.setTransactionTimeout(seconds);
    }
}

