/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.international.StatusMessages;
import org.jboss.seam.security.management.IdentityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.security.management.userAction")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=0)
public class UserAction
implements Serializable {
    private String firstname;
    private String lastname;
    private String username;
    private String password;
    private String confirm;
    private List<String> roles;
    private boolean enabled;
    private boolean newUserFlag;
    @In
    IdentityManager identityManager;

    @Begin
    public void createUser() {
        this.roles = new ArrayList<String>();
        this.newUserFlag = true;
    }

    @Begin
    public void editUser(String username) {
        this.username = username;
        this.roles = this.identityManager.getGrantedRoles(username);
        this.enabled = this.identityManager.isUserEnabled(username);
        this.newUserFlag = false;
    }

    public String save() {
        if (this.newUserFlag) {
            return this.saveNewUser();
        }
        return this.saveExistingUser();
    }

    private String saveNewUser() {
        if (this.password == null || !this.password.equals(this.confirm)) {
            StatusMessages.instance().addToControl("password", "Passwords do not match", new Object[0]);
            return "failure";
        }
        boolean success = this.identityManager.createUser(this.username, this.password, this.firstname, this.lastname);
        if (success) {
            for (String role : this.roles) {
                this.identityManager.grantRole(this.username, role);
            }
            if (!this.enabled) {
                this.identityManager.disableUser(this.username);
            }
            Conversation.instance().end();
            return "success";
        }
        return "failure";
    }

    private String saveExistingUser() {
        List<String> grantedRoles;
        if (this.password != null && !"".equals(this.password)) {
            if (!this.password.equals(this.confirm)) {
                StatusMessages.instance().addToControl("password", "Passwords do not match", new Object[0]);
                return "failure";
            }
            this.identityManager.changePassword(this.username, this.password);
        }
        if ((grantedRoles = this.identityManager.getGrantedRoles(this.username)) != null) {
            for (String role : grantedRoles) {
                if (this.roles.contains(role)) continue;
                this.identityManager.revokeRole(this.username, role);
            }
        }
        for (String role : this.roles) {
            if (grantedRoles != null && grantedRoles.contains(role)) continue;
            this.identityManager.grantRole(this.username, role);
        }
        if (this.enabled) {
            this.identityManager.enableUser(this.username);
        } else {
            this.identityManager.disableUser(this.username);
        }
        Conversation.instance().end();
        return "success";
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

