/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.management.IdentityStore;
import org.jboss.seam.security.management.JpaIdentityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.EVENT)
@Name(value="org.jboss.seam.security.identityManager")
@Install(precedence=0)
@BypassInterceptors
public class IdentityManager
implements Serializable {
    public static final String USER_PERMISSION_NAME = "seam.user";
    public static final String ROLE_PERMISSION_NAME = "seam.role";
    public static final String PERMISSION_CREATE = "create";
    public static final String PERMISSION_READ = "read";
    public static final String PERMISSION_UPDATE = "update";
    public static final String PERMISSION_DELETE = "delete";
    private static final LogProvider log = Logging.getLogProvider(IdentityManager.class);
    private IdentityStore identityStore;
    private IdentityStore roleIdentityStore;

    @Create
    public void create() {
        this.initIdentityStore();
    }

    protected void initIdentityStore() {
        if (this.identityStore == null) {
            this.identityStore = (IdentityStore)Component.getInstance(JpaIdentityStore.class, true);
        }
        if (this.roleIdentityStore == null && this.identityStore != null) {
            this.roleIdentityStore = this.identityStore;
        }
        if (this.identityStore == null || this.roleIdentityStore == null) {
            log.warn("no identity store available - please configure an identityStore if identity management is required.");
        }
    }

    public static IdentityManager instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("No active event context");
        }
        IdentityManager instance = (IdentityManager)Component.getInstance(IdentityManager.class, ScopeType.EVENT);
        if (instance == null) {
            throw new IllegalStateException("No IdentityManager could be created");
        }
        return instance;
    }

    public boolean createUser(String name, String password) {
        return this.createUser(name, password, null, null);
    }

    public boolean createUser(String name, String password, String firstname, String lastname) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_CREATE);
        return this.identityStore.createUser(name, password, firstname, lastname);
    }

    public boolean deleteUser(String name) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_DELETE);
        return this.identityStore.deleteUser(name);
    }

    public boolean enableUser(String name) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_UPDATE);
        return this.identityStore.enableUser(name);
    }

    public boolean disableUser(String name) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_UPDATE);
        return this.identityStore.disableUser(name);
    }

    public boolean changePassword(String name, String password) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_UPDATE);
        return this.identityStore.changePassword(name, password);
    }

    public boolean isUserEnabled(String name) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_READ);
        return this.identityStore.isUserEnabled(name);
    }

    public boolean grantRole(String name, String role) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_UPDATE);
        return this.roleIdentityStore.grantRole(name, role);
    }

    public boolean revokeRole(String name, String role) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_UPDATE);
        return this.roleIdentityStore.revokeRole(name, role);
    }

    public boolean createRole(String role) {
        Identity.instance().checkPermission(ROLE_PERMISSION_NAME, PERMISSION_CREATE);
        return this.roleIdentityStore.createRole(role);
    }

    public boolean deleteRole(String role) {
        Identity.instance().checkPermission(ROLE_PERMISSION_NAME, PERMISSION_DELETE);
        return this.roleIdentityStore.deleteRole(role);
    }

    public boolean addRoleToGroup(String role, String group) {
        Identity.instance().checkPermission(ROLE_PERMISSION_NAME, PERMISSION_UPDATE);
        return this.roleIdentityStore.addRoleToGroup(role, group);
    }

    public boolean removeRoleFromGroup(String role, String group) {
        Identity.instance().checkPermission(ROLE_PERMISSION_NAME, PERMISSION_UPDATE);
        return this.roleIdentityStore.removeRoleFromGroup(role, group);
    }

    public boolean userExists(String name) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_READ);
        return this.identityStore.userExists(name);
    }

    public boolean roleExists(String name) {
        return this.roleIdentityStore.roleExists(name);
    }

    public List<String> listUsers() {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_READ);
        List<String> users = this.identityStore.listUsers();
        Collections.sort(users, new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                return value1.compareTo(value2);
            }
        });
        return users;
    }

    public List<String> listUsers(String filter) {
        Identity.instance().checkPermission(USER_PERMISSION_NAME, PERMISSION_READ);
        List<String> users = this.identityStore.listUsers(filter);
        Collections.sort(users, new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                return value1.compareTo(value2);
            }
        });
        return users;
    }

    public List<String> listRoles() {
        Identity.instance().checkPermission(ROLE_PERMISSION_NAME, PERMISSION_READ);
        List<String> roles = this.roleIdentityStore.listRoles();
        Collections.sort(roles, new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                return value1.compareTo(value2);
            }
        });
        return roles;
    }

    public List<String> listGrantableRoles() {
        List<String> roles = this.roleIdentityStore.listGrantableRoles();
        Collections.sort(roles, new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                return value1.compareTo(value2);
            }
        });
        return roles;
    }

    public List<String> getGrantedRoles(String name) {
        return this.roleIdentityStore.getGrantedRoles(name);
    }

    public List<String> getImpliedRoles(String name) {
        return this.roleIdentityStore.getImpliedRoles(name);
    }

    public List<String> getRoleGroups(String name) {
        return this.roleIdentityStore.getRoleGroups(name);
    }

    public boolean authenticate(String username, String password) {
        return this.identityStore.authenticate(username, password);
    }

    public IdentityStore getIdentityStore() {
        return this.identityStore;
    }

    public void setIdentityStore(IdentityStore identityStore) {
        this.identityStore = identityStore;
    }

    public IdentityStore getRoleIdentityStore() {
        return this.roleIdentityStore;
    }

    public void setRoleIdentityStore(IdentityStore roleIdentityStore) {
        this.roleIdentityStore = roleIdentityStore;
    }

    public boolean isEnabled() {
        return this.identityStore != null && this.roleIdentityStore != null;
    }
}

