/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.persistence;

import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.profileservice.persistence.AbstractManagedObjectRecreation;
import org.jboss.profileservice.persistence.AbstractValueRecreation;
import org.jboss.profileservice.persistence.ManagedObjectRecreationHelper;
import org.jboss.profileservice.persistence.xml.PersistedManagedObject;

public class DefaultRecreationDelegate
extends AbstractManagedObjectRecreation {
    private final ManagedObjectRecreationHelper helper;

    public DefaultRecreationDelegate(AbstractValueRecreation valueRecreation, ManagedObjectRecreationHelper helper) {
        super(valueRecreation);
        if (helper == null) {
            throw new IllegalArgumentException("null helper");
        }
        this.helper = helper;
    }

    public ManagedObject createManagedObject(PersistedManagedObject persisted) {
        ManagedObject mo;
        if (persisted == null) {
            throw new IllegalArgumentException("null persisted managed object.");
        }
        String className = persisted.getTemplateName();
        if (className == null) {
            className = persisted.getClassName();
        }
        if ((mo = this.createManagedObjectSkeleton(className)) == null) {
            throw new RuntimeException("could not recreate managed object for class " + className);
        }
        return this.updateManagedObject(persisted, mo);
    }

    public ManagedObject updateManagedObject(PersistedManagedObject persisted, ManagedObject mo) {
        if (persisted == null) {
            throw new IllegalArgumentException("null persisted managed object");
        }
        if (mo == null) {
            throw new IllegalArgumentException("null managed object");
        }
        this.processProperties(persisted, mo);
        return mo;
    }

    protected ManagedObject createManagedObjectSkeleton(String className) {
        try {
            return this.helper.createManagedObjectSkeleton(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("could not recreate attachment", cnfe);
        }
    }

    @Override
    protected void setValue(String name, ManagedProperty property, Object attachment) {
        try {
            this.helper.setValue(name, property, attachment);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not set value for property: " + property, e);
        }
    }
}

