/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.StoppableThread;
import org.jboss.remoting.transport.multiplex.utility.VirtualSelector;

public class Protocol {
    protected static final Logger log = Logger.getLogger(Protocol.class);
    public static final int MP_CONNECT = 0;
    public static final int MP_CONNECTED = 1;
    public static final int MP_VERIFY_CONNECTION = 2;
    public static final int MP_OUTPUT_SHUTDOWN = 4;
    public static final int MP_DISCONNECT = 5;
    public static final int MP_REGISTER_REMOTE_SERVER = 6;
    public static final int MP_UNREGISTER_REMOTE_SERVER = 7;
    public static final int MP_REQUEST_MANAGER_SHUTDOWN = 8;
    public static final int MP_ERROR = 9;
    public static final int MP_TRUE = 10;
    public static final int MP_FALSE = 11;
    private MultiplexingInputStream protocolInputStream;
    private MultiplexingOutputStream serverSocketOutputStream;
    private MultiplexingOutputStream protocolOutputStream;
    private boolean trace;
    private boolean debug;
    private boolean info;

    public static BackChannelThread getBackChannelThread(VirtualSelector virtualSelector) {
        return new BackChannelThread(virtualSelector);
    }

    public Protocol(MultiplexingManager manager) throws IOException {
        this.protocolInputStream = manager.getAnInputStream(SocketId.PROTOCOL_SOCKET_ID, null);
        this.protocolOutputStream = new MultiplexingOutputStream(manager, SocketId.BACKCHANNEL_SOCKET_ID);
        this.serverSocketOutputStream = new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_ID);
        this.trace = log.isTraceEnabled();
        this.debug = log.isDebugEnabled();
        this.info = log.isInfoEnabled();
    }

    public SocketId connect(MultiplexingInputStream is, SocketId socketId) throws IOException {
        return this.connect(is, socketId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketId connect(MultiplexingInputStream is, SocketId socketId, int timeout) throws IOException {
        log.debug((Object)"entering Protocol.connect()");
        long start = System.currentTimeMillis();
        int timeLeft = 0;
        int savedTimeout = is.getTimeout();
        MultiplexingOutputStream multiplexingOutputStream = this.serverSocketOutputStream;
        synchronized (multiplexingOutputStream) {
            this.serverSocketOutputStream.write(0);
            if (this.debug) {
                log.debug((Object)"Protocol.connect(): wrote: CONNECT (0)");
            }
            this.serverSocketOutputStream.writeInt(socketId.getPort());
            if (this.debug) {
                log.debug((Object)("Protocol.connect(): wrote port: " + socketId.getPort()));
            }
        }
        try {
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException();
            }
            is.setTimeout(timeLeft);
            int messageType = is.read();
            if (this.debug) {
                log.debug((Object)("Protocol.connect(): read message type: " + messageType));
            }
            switch (messageType) {
                case 1: {
                    if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                        throw new SocketTimeoutException("connect timed out");
                    }
                    is.setTimeout(timeLeft);
                    int remotePort = is.readInt();
                    if (this.debug) {
                        log.debug((Object)("Protocol.connect(): read port: " + remotePort));
                    }
                    SocketId socketId2 = new SocketId(remotePort);
                    return socketId2;
                }
            }
            try {
                log.error((Object)("Protocol.connect(): expecting a CONNECTED message: received: " + messageType));
                throw new IOException("Protocol.connect(): expecting a CONNECTED message: received: " + messageType);
            }
            catch (SocketTimeoutException e) {
                log.info((Object)"timeout in Protocol.connect()");
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e);
                StackTraceElement[] stes = e.getStackTrace();
                for (int i = 0; i < stes.length; ++i) {
                    log.error((Object)stes[i].toString());
                }
                throw new IOException(e.getMessage());
            }
        }
        finally {
            is.setTimeout(savedTimeout);
        }
    }

    /*
     * Exception decompiling
     */
    public SocketId acceptConnect(MultiplexingInputStream is, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void answerConnect(MultiplexingOutputStream os, int port) throws IOException {
        os.write(1);
        if (this.debug) {
            log.debug((Object)"Protocol.answerConnect(): wrote: CONNECTED (1)");
        }
        os.writeInt(port);
        if (this.debug) {
            log.debug((Object)("Protocol.answerConnect(): wrote port: " + port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOutputShutdown(SocketId socketId) {
        int port = socketId.getPort();
        try {
            MultiplexingOutputStream multiplexingOutputStream = this.protocolOutputStream;
            synchronized (multiplexingOutputStream) {
                this.protocolOutputStream.write(4, port);
                this.protocolOutputStream.writeInt(port, port);
            }
            if (this.debug) {
                log.debug((Object)("Protocol.notifyOutputShutdown(): wrote: OUTPUT_SHUTDOWN (4) for port: " + port));
            }
        }
        catch (IOException ignored) {
            log.error((Object)("Protocol.notifyOutputShutdown(): unable to send MP_OUTPUT_SHUTDOWN message to port: " + port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(SocketId socketId) {
        int port = socketId.getPort();
        try {
            MultiplexingOutputStream multiplexingOutputStream = this.protocolOutputStream;
            synchronized (multiplexingOutputStream) {
                this.protocolOutputStream.write(5, port);
                this.protocolOutputStream.writeInt(port, port);
            }
            if (this.debug) {
                log.debug((Object)("Protocol.disconnect(): wrote: DISCONNECT (1) for port: " + port));
            }
        }
        catch (IOException ignored) {
            log.error((Object)("Protocol.disconnect(): unable to send DISCONNECT message to port: " + port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemoteServerSocket(int timeout) throws IOException {
        int answer = 11;
        MultiplexingInputStream multiplexingInputStream = this.protocolInputStream;
        synchronized (multiplexingInputStream) {
            MultiplexingOutputStream multiplexingOutputStream = this.protocolOutputStream;
            synchronized (multiplexingOutputStream) {
                this.protocolOutputStream.write(6);
            }
            if (this.debug) {
                log.debug((Object)"Protocol.registerRemoteServerSocket(): wrote: REGISTER_REMOTE_SERVER (6)");
            }
            this.protocolInputStream.setTimeout(timeout);
            answer = this.protocolInputStream.read();
        }
        if (this.debug) {
            log.debug((Object)("Protocol.registerRemoteServerSocket(): read: " + (answer == 10 ? "true" : "false")));
        }
        if (answer == 11) {
            throw new IOException("unable to register remote socket");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRemoteServerSocket() {
        log.debug((Object)"unregisterRemoteServerSocket()");
        try {
            MultiplexingOutputStream multiplexingOutputStream = this.protocolOutputStream;
            synchronized (multiplexingOutputStream) {
                this.protocolOutputStream.write(7);
            }
            if (this.debug) {
                log.debug((Object)"Protocol.disconnect(): wrote: UNREGISTER_REMOTE_SERVER (7)");
            }
        }
        catch (IOException ignored) {
            log.error((Object)"Protocol.unregisterRemoteServerSocket(): unable to send UNREGISTER_REMOTE_SERVER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestManagerShutdown(int timeout) throws IOException {
        boolean answer;
        int b;
        MultiplexingInputStream multiplexingInputStream = this.protocolInputStream;
        synchronized (multiplexingInputStream) {
            MultiplexingOutputStream multiplexingOutputStream = this.protocolOutputStream;
            synchronized (multiplexingOutputStream) {
                this.protocolOutputStream.write(8, -1);
            }
            if (this.debug) {
                log.debug((Object)"Protocol.requestManagerShutdown(): wrote: REQUEST_MANAGER_SHUTDOWN (8)");
            }
            this.protocolInputStream.setTimeout(timeout);
            b = this.protocolInputStream.read();
        }
        boolean bl = answer = b == 10;
        if (this.debug) {
            log.debug((Object)("Protocol.requestManagerShutdown(): read: " + answer));
        }
        return answer;
    }

    static class BackChannelThread
    extends StoppableThread {
        VirtualSelector virtualSelector;
        VirtualSocket socket;

        public BackChannelThread(VirtualSelector virtualSelector) {
            this.virtualSelector = virtualSelector;
        }

        @Override
        public void shutdown() {
            log.debug((Object)"back channel thread: beginning shut down");
            super.shutdown();
            this.virtualSelector.close();
            this.interrupt();
        }

        @Override
        protected void doInit() {
            log.debug((Object)"back channel thread starting");
        }

        @Override
        protected void doRun() {
            MultiplexingManager manager = null;
            Map streamMap = this.virtualSelector.select();
            if (streamMap == null) {
                return;
            }
            Iterator it = streamMap.keySet().iterator();
            block12: while (it.hasNext()) {
                try {
                    MultiplexingInputStream is = (MultiplexingInputStream)it.next();
                    if (is.available() == 0) {
                        log.debug((Object)"available == 0");
                        this.virtualSelector.remove(is);
                        continue;
                    }
                    manager = (MultiplexingManager)streamMap.get(is);
                    if (manager == null) continue;
                    OutputStream os = manager.getBackchannelOutputStream();
                    int messageType = is.read();
                    log.debug((Object)("back channel thread: read message type: " + messageType));
                    switch (messageType) {
                        case 4: {
                            int port = is.readInt();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("back channel thread: read OUTPUT_SHUTDOWN for port: " + port));
                            }
                            this.socket = manager.getSocketByLocalPort(new SocketId(port));
                            if (this.socket == null) {
                                log.info((Object)("back channel thread (OUTPUT_SHUTDOWN): unable to retrieve socket at port: " + port));
                                continue block12;
                            }
                            this.socket.handleRemoteOutputShutDown();
                            continue block12;
                        }
                        case 5: {
                            int port = is.readInt();
                            log.debug((Object)("back channel thread: read DISCONNECT for port: " + port));
                            this.socket = manager.getSocketByLocalPort(new SocketId(port));
                            if (this.socket == null) {
                                log.info((Object)("back channel thread (DISCONNECT): unable to retrieve socket at port: " + port));
                                continue block12;
                            }
                            this.socket.handleRemoteDisconnect();
                            continue block12;
                        }
                        case 6: {
                            log.debug((Object)"back channel thread: read REGISTER_REMOTE_SERVER");
                            int answer = 10;
                            try {
                                manager.registerRemoteServerSocket();
                            }
                            catch (Exception e) {
                                answer = 11;
                                log.info((Object)"back channel thread: unable to register remote server", (Throwable)e);
                            }
                            os.write(answer);
                            continue block12;
                        }
                        case 7: {
                            log.debug((Object)"back channel thread: read UNREGISTER_REMOTE_SERVER");
                            manager.unRegisterRemoteServerSocket();
                            continue block12;
                        }
                        case 8: {
                            int answer;
                            log.debug((Object)"back channel thread: read REQUEST_MANAGER_SHUTDOWN");
                            int n = answer = manager.respondToShutdownRequest() ? 10 : 11;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("back channel thread: writing " + answer));
                            }
                            os.write(answer);
                            continue block12;
                        }
                    }
                    log.error((Object)("unexpected message type in back channel thread: " + messageType));
                }
                catch (InterruptedIOException e) {
                    if (this.isRunning()) {
                        log.error((Object)"back channel thread: i/o interruption", (Throwable)e);
                        continue;
                    }
                    log.error((Object)"back channel thread: i/o interruption");
                }
                catch (IOException e) {
                    if (this.isRunning()) {
                        log.error((Object)("back channel thread: i/o error: " + manager.getSocket().toString()), (Throwable)e);
                        continue;
                    }
                    log.error((Object)"back channel thread: i/o error");
                }
            }
        }

        @Override
        protected void doShutDown() {
            log.debug((Object)"back channel thread shutting down");
        }
    }
}

