/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Date;
import org.hsqldb.lib.HsqlArrayHeap;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.ThreadFactory;

public final class HsqlTimer
implements ObjectComparator,
ThreadFactory {
    protected final TaskQueue taskQueue = new TaskQueue(16, this);
    protected final TaskRunner taskRunner = new TaskRunner();
    protected Thread taskRunnerThread;
    protected final ThreadFactory threadFactory;
    protected volatile boolean isShutdown;
    static int nowCount = 0;

    public HsqlTimer() {
        this(null);
    }

    public HsqlTimer(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory == null ? this : threadFactory;
    }

    public int compare(Object object, Object object2) {
        long l;
        long l2 = ((Task)object).getNextScheduled();
        return l2 < (l = ((Task)object2).getNextScheduled()) ? -1 : (l2 == l ? 0 : 1);
    }

    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("HSQLDB Timer @" + Integer.toHexString(this.hashCode()));
        thread.setDaemon(true);
        return thread;
    }

    public synchronized Thread getThread() {
        return this.taskRunnerThread;
    }

    public synchronized void restart() throws IllegalStateException {
        if (this.isShutdown) {
            throw new IllegalStateException("isShutdown==true");
        }
        if (this.taskRunnerThread == null) {
            this.taskRunnerThread = this.threadFactory.newThread(this.taskRunner);
            this.taskRunnerThread.start();
        } else {
            this.taskQueue.unpark();
        }
    }

    public Object scheduleAfter(long l, Runnable runnable) throws IllegalArgumentException {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(HsqlTimer.now() + l, runnable, 0L, false);
    }

    public Object scheduleAt(Date date, Runnable runnable) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("date == null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(date.getTime(), runnable, 0L, false);
    }

    public Object schedulePeriodicallyAt(Date date, long l, Runnable runnable, boolean bl) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("date == null");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(date.getTime(), runnable, l, bl);
    }

    public Object schedulePeriodicallyAfter(long l, long l2, Runnable runnable, boolean bl) throws IllegalArgumentException {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(HsqlTimer.now() + l, runnable, l2, bl);
    }

    public synchronized void shutdown() {
        if (!this.isShutdown) {
            this.isShutdown = true;
            this.taskQueue.cancelAllTasks();
        }
    }

    public synchronized void shutdownImmediately() {
        if (!this.isShutdown) {
            Thread thread = this.taskRunnerThread;
            this.isShutdown = true;
            if (thread != null && thread.isAlive()) {
                thread.interrupt();
            }
            this.taskQueue.cancelAllTasks();
        }
    }

    public static void cancel(Object object) {
        if (object instanceof Task) {
            ((Task)object).cancel();
        }
    }

    public static boolean isCancelled(Object object) {
        return object instanceof Task ? ((Task)object).isCancelled() : true;
    }

    public static boolean isFixedRate(Object object) {
        if (object instanceof Task) {
            Task task = (Task)object;
            return task.relative && task.period > 0L;
        }
        return false;
    }

    public static boolean isFixedDelay(Object object) {
        if (object instanceof Task) {
            Task task = (Task)object;
            return !task.relative && task.period > 0L;
        }
        return false;
    }

    public static boolean isPeriodic(Object object) {
        return object instanceof Task ? ((Task)object).period > 0L : false;
    }

    public static Date getLastScheduled(Object object) {
        if (object instanceof Task) {
            Task task = (Task)object;
            long l = task.getLastScheduled();
            return l == 0L ? null : new Date(l);
        }
        return null;
    }

    public static Object setPeriod(Object object, long l) {
        return object instanceof Task ? ((Task)object).setPeriod(l) : object;
    }

    public static Date getNextScheduled(Object object) {
        if (object instanceof Task) {
            Task task = (Task)object;
            long l = task.isCancelled() ? 0L : task.getNextScheduled();
            return l == 0L ? null : new Date(l);
        }
        return null;
    }

    protected Task addTask(long l, Runnable runnable, long l2, boolean bl) {
        if (this.isShutdown) {
            throw new IllegalStateException("shutdown");
        }
        Task task = new Task(l, runnable, l2, bl);
        this.taskQueue.addTask(task);
        this.restart();
        return task;
    }

    protected synchronized void clearThread() {
        this.taskRunnerThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Task nextTask() {
        try {
            while (!this.isShutdown || Thread.interrupted()) {
                long l;
                long l2;
                Task task;
                TaskQueue taskQueue = this.taskQueue;
                synchronized (taskQueue) {
                    task = this.taskQueue.peekTask();
                    if (task == null) {
                        break;
                    }
                    l2 = task.next;
                    l = System.currentTimeMillis();
                    long l3 = l2 - l;
                    if (l3 > 0L) {
                        this.taskQueue.park(l3);
                        continue;
                    }
                    this.taskQueue.removeTask();
                }
                long l4 = task.period;
                if (l4 > 0L) {
                    if (task.relative) {
                        long l5 = l - l2;
                        if (l5 > l4) {
                            l4 = 0L;
                        } else if (l5 > 0L) {
                            l4 -= l5;
                        }
                    }
                    task.updateSchedule(l, l + l4);
                    this.taskQueue.addTask(task);
                }
                return task;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private static long now() {
        ++nowCount;
        return System.currentTimeMillis();
    }

    protected static class TaskQueue
    extends HsqlArrayHeap {
        TaskQueue(int n, ObjectComparator objectComparator) {
            super(n, objectComparator);
        }

        void addTask(Task task) {
            super.add(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelAllTasks() {
            int n;
            TaskQueue taskQueue = this;
            synchronized (taskQueue) {
                Object[] objectArray = this.heap;
                n = this.count;
                this.heap = new Object[1];
                this.count = 0;
            }
            for (int i = 0; i < n; ++i) {
                ((Task)objectArray[i]).cancelled = true;
            }
        }

        synchronized void park(long l) throws InterruptedException {
            this.wait(l);
        }

        synchronized Task peekTask() {
            while (this.heap[0] != null && ((Task)this.heap[0]).isCancelled()) {
                super.remove();
            }
            return (Task)this.heap[0];
        }

        synchronized void signalTaskCancelled(Task task) {
            if (task == this.heap[0]) {
                super.remove();
                this.notify();
            }
        }

        Task removeTask() {
            return (Task)super.remove();
        }

        synchronized void unpark() {
            this.notify();
        }
    }

    protected class Task {
        Runnable runnable;
        long period;
        long last;
        long next;
        boolean cancelled = false;
        private Object cancel_mutex = new Object();
        final boolean relative;

        Task(long l, Runnable runnable, long l2, boolean bl) {
            this.next = l;
            this.runnable = runnable;
            this.period = l2;
            this.relative = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            Object object = this.cancel_mutex;
            synchronized (object) {
                if (!this.cancelled) {
                    this.cancelled = true;
                    HsqlTimer.this.taskQueue.signalTaskCancelled(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isCancelled() {
            Object object = this.cancel_mutex;
            synchronized (object) {
                return this.cancelled;
            }
        }

        synchronized long getLastScheduled() {
            return this.last;
        }

        synchronized long getNextScheduled() {
            return this.next;
        }

        synchronized void updateSchedule(long l, long l2) {
            this.last = l;
            this.next = l2;
        }

        synchronized Object setPeriod(long l) {
            if (this.period == l || this.isCancelled()) {
                return this;
            }
            if (l > this.period) {
                this.period = l;
                return this;
            }
            this.cancel();
            return HsqlTimer.this.addTask(HsqlTimer.now(), this.runnable, l, this.relative);
        }
    }

    protected class TaskRunner
    implements Runnable {
        protected TaskRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Task task;
                while ((task = HsqlTimer.this.nextTask()) != null) {
                    task.runnable.run();
                }
            }
            finally {
                HsqlTimer.this.clearThread();
            }
        }
    }
}

