/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.metadata.jbmeta;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.managed.bean.metadata.MethodMetadata;

public class MethodMetadataImpl
implements MethodMetadata {
    private String methodName;
    private String[] params;
    private String declaringClass;

    public MethodMetadataImpl(Method method) {
        this.methodName = method.getName();
        this.declaringClass = method.getDeclaringClass().getName();
        Class<?>[] methodParams = method.getParameterTypes();
        this.params = new String[methodParams.length];
        int i = 0;
        for (Class<?> methodParam : methodParams) {
            this.params[i++] = methodParam.getName();
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getMethodParams() {
        return this.params;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodMetadataImpl)) {
            return false;
        }
        MethodMetadataImpl other = (MethodMetadataImpl)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return Arrays.equals(this.params, other.params);
    }
}

