/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.ClassifiedBindingAndPointcutCollection;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;
import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackDefinition;
import org.jboss.aop.pointcut.AnnotationMatcher;
import org.jboss.aop.pointcut.PointcutMethodMatch;
import org.jboss.aop.proxy.container.InstanceProxyContainer;
import org.jboss.aop.util.Advisable;
import org.jboss.aop.util.BindingClassifier;
import org.jboss.util.MethodHashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveAspectBinder {
    protected Class<?> clazz;
    protected HashSet<AspectDefinition> aspects = new HashSet();
    protected HashMap<Method, ArrayList<InterceptorFactory>> methodAdvices = new HashMap();
    protected HashMap<Constructor<?>, ArrayList<InterceptorFactory>> constructorAdvices = new HashMap();
    protected HashMap<Field, ArrayList<InterceptorFactory>> fieldReadAdvices = new HashMap();
    protected HashMap<Field, ArrayList<InterceptorFactory>> fieldWriteAdvices = new HashMap();
    protected Advisor advisor;
    protected boolean isInstanceContainer;
    TLongObjectHashMap methodMap = new TLongObjectHashMap();
    protected Map<Object, Set<LifecycleCallbackDefinition>> lifecycleCallbacks = new HashMap<Object, Set<LifecycleCallbackDefinition>>();
    boolean initialisedAspects;
    boolean intitialisedLifecycleCallbacks;

    public ReflectiveAspectBinder(Class<?> clazz, Advisor advisor) {
        this.clazz = clazz;
        this.advisor = advisor;
        this.isInstanceContainer = InstanceProxyContainer.class == advisor.getClass();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<AspectDefinition> getAspects() {
        if (!this.initialisedAspects) {
            ClassifiedBindingAndPointcutCollection bindingCol = this.advisor.getManager().getBindingCollection();
            AspectManager.lock.lockRead();
            try {
                this.bindMethodAdvices(this.clazz, bindingCol);
                this.bindConstructorAdvices(bindingCol);
                this.bindFieldAdvices(bindingCol);
            }
            finally {
                AspectManager.lock.unlockRead();
            }
        }
        return this.aspects;
    }

    public Map<Object, Set<LifecycleCallbackDefinition>> getLifecycleCallbacks() {
        if (!this.intitialisedLifecycleCallbacks) {
            this.bindLifecycles();
        }
        return this.lifecycleCallbacks;
    }

    public HashMap<Method, ArrayList<InterceptorFactory>> getMethodAdvices() {
        return this.methodAdvices;
    }

    public HashMap<Constructor<?>, ArrayList<InterceptorFactory>> getConstructorAdvices() {
        return this.constructorAdvices;
    }

    public HashMap<Field, ArrayList<InterceptorFactory>> getFieldReadAdvices() {
        return this.fieldReadAdvices;
    }

    public HashMap<Field, ArrayList<InterceptorFactory>> getFieldWriteAdvices() {
        return this.fieldWriteAdvices;
    }

    public void createMethodMap(final Class<?> superClass) {
        try {
            if (superClass == null || superClass == Object.class && !this.isInstanceContainer) {
                return;
            }
            this.createMethodMap(superClass.getSuperclass());
            Method[] methods = AccessController.doPrivileged(new PrivilegedExceptionAction<Method[]>(){

                @Override
                public Method[] run() throws Exception {
                    return superClass.getDeclaredMethods();
                }
            });
            for (int i = 0; i < methods.length; ++i) {
                if (!Advisable.isAdvisable(methods[i])) continue;
                long hash = MethodHashing.methodHash((Method)methods[i]);
                this.methodMap.put(hash, (Object)methods[i]);
            }
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void bindMethodAdvices(Class<?> superClass, ClassifiedBindingAndPointcutCollection bindingCol) {
        this.createMethodMap(superClass);
        if (this.methodMap != null) {
            Collection<AdviceBinding> bindings = bindingCol.getMethodExecutionBindings();
            Object[] methods = this.methodMap.getValues();
            for (int i = 0; i < methods.length; ++i) {
                this.bindMethodAdvice((Method)methods[i], bindings);
            }
        }
    }

    void bindConstructorAdvices(ClassifiedBindingAndPointcutCollection bindingCol) {
        Constructor<?>[] cons = AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

            @Override
            public Constructor<?>[] run() {
                return ReflectiveAspectBinder.this.clazz.getDeclaredConstructors();
            }
        });
        Collection<AdviceBinding> bindings = bindingCol.getConstructorExecutionBindings();
        for (int i = 0; i < cons.length; ++i) {
            this.bindConstructorAdvice(cons[i], bindings);
        }
    }

    protected void bindFieldAdvices(ClassifiedBindingAndPointcutCollection bindingCol) {
        int i;
        Field[] fields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return ReflectiveAspectBinder.this.clazz.getDeclaredFields();
            }
        });
        Collection<AdviceBinding> bindings = bindingCol.getFieldReadBindings();
        for (i = 0; i < fields.length; ++i) {
            this.bindFieldGetAdvice(fields[i], bindings);
        }
        bindings = bindingCol.getFieldWriteBindings();
        for (i = 0; i < fields.length; ++i) {
            this.bindFieldSetAdvice(fields[i], bindings);
        }
    }

    protected boolean matches(AnnotationIntroduction ai, Object element) {
        AnnotationMatcher matcher = new AnnotationMatcher(this.advisor, element);
        return (Boolean)ai.getTarget().jjtAccept(matcher, null);
    }

    @Deprecated
    protected void bindMethodAdvice(Method mi, Map<String, AdviceBinding> bindings) {
        ArrayList<InterceptorFactory> advices = this.methodAdvices.get(mi);
        for (AdviceBinding binding : bindings.values()) {
            PointcutMethodMatch pmatch;
            if (!BindingClassifier.isMethodExecution(binding) || (pmatch = binding.getPointcut().matchesExecution(this.advisor, mi)) == null || !pmatch.isMatch()) continue;
            if (advices == null) {
                advices = new ArrayList();
                this.methodAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindMethodAdvice(Method mi, Collection<AdviceBinding> bindings) {
        ArrayList<InterceptorFactory> advices = this.methodAdvices.get(mi);
        for (AdviceBinding binding : bindings) {
            PointcutMethodMatch pmatch = binding.getPointcut().matchesExecution(this.advisor, mi);
            if (pmatch == null || !pmatch.isMatch()) continue;
            if (advices == null) {
                advices = new ArrayList();
                this.methodAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    @Deprecated
    protected void bindConstructorAdvice(Constructor<?> mi, Map<String, AdviceBinding> bindings) {
        ArrayList<InterceptorFactory> advices = this.constructorAdvices.get(mi);
        for (AdviceBinding binding : bindings.values()) {
            if (!BindingClassifier.isConstructorExecution(binding) || !binding.getPointcut().matchesExecution(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList();
                this.constructorAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindConstructorAdvice(Constructor<?> mi, Collection<AdviceBinding> bindings) {
        ArrayList<InterceptorFactory> advices = this.constructorAdvices.get(mi);
        for (AdviceBinding binding : bindings) {
            if (!binding.getPointcut().matchesExecution(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList();
                this.constructorAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    @Deprecated
    protected void bindFieldGetAdvice(Field mi, Map<String, AdviceBinding> bindings) {
        ArrayList<InterceptorFactory> advices = this.fieldReadAdvices.get(mi);
        for (AdviceBinding binding : bindings.values()) {
            if (!BindingClassifier.isGet(binding) || !binding.getPointcut().matchesGet(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList();
                this.fieldReadAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindFieldGetAdvice(Field mi, Collection<AdviceBinding> bindings) {
        ArrayList<InterceptorFactory> advices = this.fieldReadAdvices.get(mi);
        for (AdviceBinding binding : bindings) {
            if (!binding.getPointcut().matchesGet(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList();
                this.fieldReadAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    @Deprecated
    protected void bindFieldSetAdvice(Field mi, Map<String, AdviceBinding> bindings) {
        ArrayList<InterceptorFactory> advices = this.fieldWriteAdvices.get(mi);
        for (AdviceBinding binding : bindings.values()) {
            if (!BindingClassifier.isSet(binding) || !binding.getPointcut().matchesSet(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList();
                this.fieldWriteAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindFieldSetAdvice(Field mi, Collection<AdviceBinding> bindings) {
        ArrayList<InterceptorFactory> advices = this.fieldWriteAdvices.get(mi);
        for (AdviceBinding binding : bindings) {
            if (!binding.getPointcut().matchesSet(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList();
                this.fieldWriteAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindLifecycles() {
        for (LifecycleCallbackBinding binding : this.advisor.getManager().getLifecycleBindings().values()) {
            if (!binding.matches(this.advisor, this.clazz)) continue;
            Object state = binding.getControllerState();
            Set<LifecycleCallbackDefinition> callbacks = this.lifecycleCallbacks.get(state);
            if (callbacks == null) {
                callbacks = new LinkedHashSet<LifecycleCallbackDefinition>();
                this.lifecycleCallbacks.put(state, callbacks);
            }
            List<LifecycleCallbackDefinition> boundCallbacks = binding.getLifecycleCallbacks();
            for (LifecycleCallbackDefinition callback : boundCallbacks) {
                callbacks.add(callback);
            }
        }
    }
}

