/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.Ordered;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.structure.spi.helpers.AbstractStructuralDeployers;
import org.jboss.deployers.vfs.plugins.structure.StructureDeployerWrapper;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSStructuralDeployersImpl
extends AbstractStructuralDeployers
implements VFSStructuralDeployers {
    private static final Logger log = Logger.getLogger(VFSStructuralDeployersImpl.class);
    private Set<StructureDeployer> structureDeployers = new TreeSet<StructureDeployer>(Ordered.COMPARATOR);

    public VFSStructuralDeployersImpl() {
    }

    public VFSStructuralDeployersImpl(Set<StructureDeployer> structureDeployers) {
        this.setDeployers(structureDeployers);
    }

    public Set<StructureDeployer> getDeployers() {
        return this.structureDeployers;
    }

    public void setDeployers(Set<StructureDeployer> deployers) {
        if (deployers == null) {
            throw new IllegalArgumentException("Null deployers");
        }
        HashSet<StructureDeployer> oldDeployers = new HashSet<StructureDeployer>(this.structureDeployers);
        oldDeployers.removeAll(deployers);
        for (StructureDeployer deployer : oldDeployers) {
            this.removeDeployer(deployer);
        }
        HashSet<StructureDeployer> newDeployers = new HashSet<StructureDeployer>(deployers);
        newDeployers.removeAll(this.structureDeployers);
        for (StructureDeployer deployer : newDeployers) {
            this.addDeployer(deployer);
        }
    }

    public synchronized void addDeployer(StructureDeployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.structureDeployers.add(new StructureDeployerWrapper(deployer));
        log.debugf("Added structure deployer %1s", new Object[]{deployer});
    }

    public synchronized void removeDeployer(StructureDeployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.structureDeployers.remove(deployer);
        log.debugf("Removed structure deployer %1s", new Object[]{deployer});
    }

    public boolean determineStructure(VirtualFile file, StructureContext parentContext) throws DeploymentException {
        StructureMetaData structure = StructureMetaDataFactory.createStructureMetaData();
        StructureContext context = new StructureContext(file, structure, parentContext);
        boolean result = this.doDetermineStructure(context);
        if (result) {
            String relativePath = AbstractStructureDeployer.getRelativePath((VirtualFile)context.getParent(), (VirtualFile)file);
            ContextInfo recognised = structure.getContext("");
            if (recognised == null) {
                throw new IllegalStateException("Something recognised the deployment, but there is no context? " + file);
            }
            List metaDataPath = recognised.getMetaDataPath();
            ContextInfo parentContextInfo = metaDataPath == null || metaDataPath.isEmpty() ? StructureMetaDataFactory.createContextInfo((String)relativePath, (List)recognised.getClassPath()) : StructureMetaDataFactory.createContextInfo((List)recognised.getClassPath(), (List)metaDataPath, (String)relativePath);
            parentContextInfo.setModificationType(recognised.getModificationType());
            StructureMetaData structureMetaData = parentContext.getMetaData();
            structureMetaData.addContext(parentContextInfo);
            MutableAttachments attachments = (MutableAttachments)parentContextInfo.getPredeterminedManagedObjects();
            attachments.addAttachment(StructureMetaData.class, (Object)structure);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDetermineStructure(StructureContext context) throws DeploymentException {
        StructureDeployer[] theDeployers;
        VFSStructuralDeployersImpl vFSStructuralDeployersImpl = this;
        synchronized (vFSStructuralDeployersImpl) {
            if (this.structureDeployers.isEmpty()) {
                throw new IllegalStateException("No structure deployers");
            }
            theDeployers = this.structureDeployers.toArray(new StructureDeployer[this.structureDeployers.size()]);
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Determining structure for " + context.getName() + " deployers=" + Arrays.asList(theDeployers)));
        }
        boolean result = false;
        for (StructureDeployer deployer : theDeployers) {
            if (!deployer.determineStructure(context)) continue;
            if (trace) {
                log.trace((Object)(context.getName() + " recognised by " + deployer));
            }
            result = true;
            break;
        }
        if (!result && trace) {
            log.trace((Object)(context.getName() + " not recognised"));
        }
        return result;
    }

    protected void determineStructure(Deployment deployment, StructureMetaData structure) throws Exception {
        if (!(deployment instanceof VFSDeployment)) {
            throw new DeploymentException("Structure can only be determined for VFSDeployments " + deployment);
        }
        VFSDeployment vfsDeployment = (VFSDeployment)deployment;
        VirtualFile root = vfsDeployment.getRoot();
        if (root == null) {
            throw new IllegalStateException("Deployment has no root " + deployment);
        }
        StructureContext context = new StructureContext(root, structure, (VFSStructuralDeployers)this);
        if (!this.doDetermineStructure(context)) {
            throw new DeploymentException("No deployer recognised the structure of " + deployment.getName());
        }
    }
}

