/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.ejb3.BeanContext;
import org.jboss.injection.Injector;
import org.jboss.injection.PojoInjector;

public class EJBContextMethodInjector
implements Injector,
PojoInjector {
    private Method setMethod;

    public EJBContextMethodInjector(Method setMethod) {
        this.setMethod = setMethod;
        setMethod.setAccessible(true);
    }

    @Override
    public void inject(BeanContext ctx) {
        this.inject(ctx, ctx.getInstance());
    }

    @Override
    public void inject(BeanContext ctx, Object instance) {
        Object[] args = new Object[]{ctx.getEJBContext()};
        try {
            this.setMethod.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed in setting EntityManager on setter method: " + this.setMethod.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void inject(Object instance) {
        throw new RuntimeException("Illegal operation");
    }

    @Override
    public Class getInjectionClass() {
        return this.setMethod.getParameterTypes()[0];
    }
}

