/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.session;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import org.jboss.aop.Domain;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.util.MethodHashing;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.async.impl.AsyncInvocationIdUUIDImpl;
import org.jboss.ejb3.async.impl.util.concurrent.ResultUnwrappingExecutorService;
import org.jboss.ejb3.async.spi.AsyncEndpoint;
import org.jboss.ejb3.async.spi.AsyncInvocationId;
import org.jboss.ejb3.async.spi.AsyncInvocationMap;
import org.jboss.ejb3.async.spi.AsyncInvocationTaskBase;
import org.jboss.ejb3.async.spi.CurrentAsyncInvocation;
import org.jboss.ejb3.common.lang.SerializableMethod;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.core.businessobject.BusinessObjectFactory;
import org.jboss.ejb3.core.proxy.spi.CurrentRemoteProxyFactory;
import org.jboss.ejb3.core.proxy.spi.RemoteProxyFactory;
import org.jboss.ejb3.proxy.impl.factory.session.SessionProxyFactory;
import org.jboss.ejb3.proxy.impl.factory.session.SessionSpecProxyFactory;
import org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandler;
import org.jboss.ejb3.proxy.spi.container.InvokableContext;
import org.jboss.ejb3.session.SecurityActions;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.security.SecurityContext;

public abstract class SessionSpecContainer
extends SessionContainer
implements InvokableContext,
AsyncEndpoint {
    private static final Logger log = Logger.getLogger(SessionSpecContainer.class);
    private Set<Class<?>> businessInterfaces;
    private final ExecutorService asynchronousExecutor;
    private BusinessObjectFactory businessObjectFactory;
    private AsyncInvocationMap currentAsyncInvocations;

    public SessionSpecContainer(ClassLoader cl, String beanClassName, String ejbName, Domain domain, Hashtable ctxProperties, Ejb3Deployment deployment, JBossSessionBeanMetaData beanMetaData, ExecutorService asynchronousExecutor) throws ClassNotFoundException {
        super(cl, beanClassName, ejbName, domain, ctxProperties, deployment, beanMetaData);
        if (asynchronousExecutor == null) {
            throw new IllegalArgumentException("Asynchronous Executor must be specified");
        }
        this.asynchronousExecutor = new ResultUnwrappingExecutorService(asynchronousExecutor, (AsyncEndpoint)this);
    }

    public SessionSpecContainer(ClassLoader cl, String beanClassName, String ejbName, Domain domain, Hashtable ctxProperties, JBossSessionBeanMetaData beanMetaData, ExecutorService asynchronousExecutor) throws ClassNotFoundException {
        super(cl, beanClassName, ejbName, domain, ctxProperties, beanMetaData);
        if (asynchronousExecutor == null) {
            throw new IllegalArgumentException("Asynchronous Executor must be specified");
        }
        this.asynchronousExecutor = new ResultUnwrappingExecutorService(asynchronousExecutor, (AsyncEndpoint)this);
    }

    public Object invoke(Serializable session, Class<?> invokedBusinessInterface, Method method, Object[] args) throws Throwable {
        SerializableMethod sMethod = new SerializableMethod(method, invokedBusinessInterface);
        return this.invoke(session, sMethod, args);
    }

    public Object invokeAsync(Serializable session, Class<?> invokedBusinessInterface, Method method, Object[] args) throws Throwable {
        ExecutorService es = this.getAsynchronousExecutor();
        SecurityContext sc = SecurityActions.getSecurityContext();
        AsyncInvocationIdUUIDImpl id = new AsyncInvocationIdUUIDImpl();
        Future returnValue = es.submit(new AsyncInvocationTask(session, method, args, sc, (AsyncInvocationId)id));
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Object invoke(Serializable session, SerializableMethod method, Object[] args) throws Throwable {
        ClassLoader oldLoader = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassloader());
        Method actualMethod = method.toMethod(this.getClassloader());
        long hash = MethodHashing.calculateHash((Method)actualMethod);
        MethodInfo info = this.getAdvisor().getMethodInfo(hash);
        if (info == null) {
            throw new RuntimeException("Method invocation via Proxy could not be found handled for EJB " + this.getEjbName() + " : " + method.toString() + ", probable error in virtual method registration w/ Advisor for the Container");
        }
        Method unadvisedMethod = info.getUnadvisedMethod();
        SerializableMethod unadvisedSerializableMethod = new SerializableMethod(unadvisedMethod);
        long start = System.currentTimeMillis();
        try {
            Class<?> invokedBusinessInterface = Class.forName(method.getActualClassName(), false, this.getClassloader());
            if (this.isEjb2xView(invokedBusinessInterface.getName())) {
                invokedBusinessInterface = null;
            }
            this.invokeStats.callIn();
            if (unadvisedMethod != null && this.isHomeMethod(unadvisedSerializableMethod)) {
                Object object = this.invokeHomeMethod(actualMethod, args);
                return object;
            }
            if (unadvisedMethod != null && this.isEjbObjectMethod(unadvisedSerializableMethod)) {
                Object object = this.invokeEJBObjectMethod(session, info, args);
                return object;
            }
            StatefulContainerInvocation nextInvocation = new StatefulContainerInvocation(info, session, invokedBusinessInterface, this.getAsynchronousExecutor(), this);
            nextInvocation.getMetaData().addMetaData((Object)"SessionInvocation", (Object)"InvokedMethod", (Object)method);
            nextInvocation.setArguments(args);
            Object object = nextInvocation.invokeNext();
            return object;
        }
        finally {
            if (unadvisedMethod != null) {
                long end = System.currentTimeMillis();
                long elapsed = end - start;
                this.invokeStats.updateStats(unadvisedMethod, elapsed);
            }
            this.invokeStats.callOut();
            SecurityActions.setContextClassLoader(oldLoader);
        }
    }

    public Object invoke(Object proxy, SerializableMethod method, Object[] args) throws Throwable {
        Serializable sessionId = null;
        if (Proxy.isProxyClass(proxy.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(proxy);
            assert (handler instanceof SessionProxyInvocationHandler) : "Requires " + SessionProxyInvocationHandler.class.getName();
            SessionProxyInvocationHandler sHandler = (SessionProxyInvocationHandler)handler;
            sessionId = (Serializable)sHandler.getTarget();
        }
        return this.invoke(sessionId, method, args);
    }

    public boolean cancel(AsyncInvocationId id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("ID must be specified");
        }
        AsyncInvocationMap map = this.getCurrentAsyncInvocations();
        return map.put((Object)id, (Object)true) != null;
    }

    protected Object invokeHomeCreate(Method method, Object[] args) throws Exception {
        RemoteProxyFactory remoteProxyFactory;
        String ejb2xLocalInterface;
        String jndiName = null;
        boolean foundInterface = false;
        String ejb2xInterface = method.getReturnType().getName();
        JBossSessionBeanMetaData smd = this.getMetaData();
        boolean isLocal = false;
        String ejb2xRemoteInterface = smd.getRemote();
        if (ejb2xInterface.equals(ejb2xRemoteInterface)) {
            foundInterface = true;
            jndiName = smd.getJndiName();
        }
        if (!foundInterface && ejb2xInterface.equals(ejb2xLocalInterface = smd.getLocal())) {
            foundInterface = true;
            isLocal = true;
            jndiName = smd.getLocalJndiName();
        }
        if (!foundInterface) {
            throw new RuntimeException("Specified return value for " + method + " notes an EJB 2.x interface: " + ejb2xInterface + "; this could not be found as either a valid remote or local interface for EJB " + this.getEjbName());
        }
        if (!isLocal && (remoteProxyFactory = CurrentRemoteProxyFactory.get()) != null) {
            return remoteProxyFactory.create(null);
        }
        String proxyFactoryKey = this.getJndiRegistrar().getProxyFactoryRegistryKey(jndiName, smd, isLocal);
        Object factory = Ejb3RegistrarLocator.locateRegistrar().lookup((Object)proxyFactoryKey);
        assert (factory instanceof SessionProxyFactory) : "Specified factory " + factory.getClass().getName() + " is not of type " + SessionProxyFactory.class.getName() + " as required by " + StatefulContainer.class.getName() + ", but was instead " + factory;
        SessionSpecProxyFactory sessionFactory = null;
        sessionFactory = (SessionSpecProxyFactory)SessionSpecProxyFactory.class.cast(factory);
        Object proxy = sessionFactory.createProxyEjb2x();
        return proxy;
    }

    private Object invokeHomeMethod(Method method, Object[] args) throws Exception {
        if (method.getName().equals("create")) {
            return this.invokeHomeCreate(method, args);
        }
        if (method.getName().equals("remove")) {
            if (!(args[0] instanceof Handle)) {
                throw new RemoveException("EJB 3.0 Specification Violation 3.6.2.2: Session beans do not have a primary key");
            }
            this.removeHandle((Handle)args[0]);
            return null;
        }
        throw new IllegalArgumentException("illegal home method " + method);
    }

    @Deprecated
    protected boolean isHomeMethod(Method method) {
        if (EJBHome.class.isAssignableFrom(method.getDeclaringClass())) {
            return true;
        }
        return EJBLocalHome.class.isAssignableFrom(method.getDeclaringClass());
    }

    protected boolean isHomeMethod(SerializableMethod method) {
        Method invokingMethod = method.toMethod(this.getClassloader());
        return this.isHomeMethod(invokingMethod);
    }

    @Deprecated
    protected boolean isEJBObjectMethod(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.getName().equals(EJBObject.class.getName())) {
            return true;
        }
        return declaringClass.getName().equals(EJBLocalObject.class.getName());
    }

    protected boolean isEjbObjectMethod(SerializableMethod method) {
        Class<?> declaringClass = null;
        String declaringClassName = method.getDeclaringClassName();
        try {
            declaringClass = Class.forName(declaringClassName, false, this.getClassloader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invoked Method specifies a declaring class that could not be loaded by the " + ClassLoader.class.getSimpleName() + " for EJB " + this.getEjbName());
        }
        if (declaringClass.getName().equals(EJBObject.class.getName())) {
            return true;
        }
        return declaringClass.getName().equals(EJBLocalObject.class.getName());
    }

    @Deprecated
    protected boolean isHandleMethod(Method method) {
        return method.getDeclaringClass().getName().equals(Handle.class.getName());
    }

    protected boolean isHandleMethod(SerializableMethod method) {
        Method invokingMethod = method.toMethod(this.getClassloader());
        return this.isHandleMethod(invokingMethod);
    }

    protected Set<Class<?>> getBusinessInterfaces() {
        if (this.businessInterfaces == null) {
            throw new IllegalStateException("Business interfaces not yet initialized");
        }
        return this.businessInterfaces;
    }

    protected BusinessObjectFactory getBusinessObjectFactory() {
        return this.businessObjectFactory;
    }

    private boolean isEjb2xView(String intf) {
        String remote = this.getMetaData().getRemote();
        if (remote != null && remote.equals(intf)) {
            return true;
        }
        String local = this.getMetaData().getLocal();
        return local != null && local.equals(intf);
    }

    @Override
    protected void lockedStart() throws Exception {
        log.info((Object)("Starting " + this));
        HashSet set = new HashSet();
        HashSet businessInterfaceNames = new HashSet();
        if (this.getMetaData().getBusinessLocals() != null) {
            businessInterfaceNames.addAll(this.getMetaData().getBusinessLocals());
        }
        if (this.getMetaData().getBusinessRemotes() != null) {
            businessInterfaceNames.addAll(this.getMetaData().getBusinessRemotes());
        }
        for (String businessInterfaceName : businessInterfaceNames) {
            Class<?> businessInterface;
            try {
                businessInterface = Class.forName(businessInterfaceName, false, this.getClassloader());
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not find marked business interface in this EJB's ClassLoader", cnfe);
            }
            set.add(businessInterface);
        }
        this.businessInterfaces = Collections.unmodifiableSet(set);
        this.verifyBusinessObjectFactory();
        super.lockedStart();
    }

    @Override
    protected void lockedStop() throws Exception {
        log.info((Object)("Stopping " + this));
        super.lockedStop();
    }

    public ExecutorService getAsynchronousExecutor() {
        return this.asynchronousExecutor;
    }

    public void setBusinessObjectFactory(BusinessObjectFactory factory) {
        this.businessObjectFactory = factory;
    }

    protected void verifyBusinessObjectFactory() {
        log.warn((Object)("EJBTHREE-2126: container " + this + " does not verify the businessObjectFactory"));
    }

    public AsyncInvocationMap getCurrentAsyncInvocations() {
        return this.currentAsyncInvocations;
    }

    @Inject(bean="org.jboss.ejb3.async.AsyncInvocationsMap")
    public void setCurrentAsyncInvocations(AsyncInvocationMap currentAsyncInvocations) {
        this.currentAsyncInvocations = currentAsyncInvocations;
    }

    private class AsyncInvocationTask<V>
    extends AsyncInvocationTaskBase<V> {
        private final Serializable session;
        private final Method method;
        private final Object[] args;

        AsyncInvocationTask(Serializable session, Method method, Object[] args, SecurityContext sc, AsyncInvocationId id) {
            super(sc, id);
            this.session = session;
            this.method = method;
            this.args = args;
        }

        protected void before() throws Exception {
            CurrentAsyncInvocation.markCurrentInvocationOnThread((AsyncInvocationId)this.id);
        }

        protected V proceed() throws Throwable {
            return (V)SessionSpecContainer.this.invoke(this.session, null, this.method, this.args);
        }

        protected void after() throws Exception {
            CurrentAsyncInvocation.unmarkCurrentInvocationFromThread();
        }
    }
}

