/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.pool;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.InfinitePool;
import org.jboss.ejb3.pool.Pool;
import org.jboss.injection.Injector;
import org.jboss.lang.ref.WeakThreadLocal;
import org.jboss.logging.Logger;

public class ThreadlocalPool
implements Pool {
    private static final Logger log = Logger.getLogger(ThreadlocalPool.class);
    protected Pool pool = new InfinitePool();
    protected WeakThreadLocal<BeanContext> currentBeanContext = new WeakThreadLocal();
    private AtomicInteger inUse = new AtomicInteger();

    protected BeanContext create() {
        return this.pool.get();
    }

    protected BeanContext create(Class[] initTypes, Object[] initValues) {
        return this.pool.get(initTypes, initValues);
    }

    public void discard(BeanContext obj) {
        this.pool.discard(obj);
        this.inUse.decrementAndGet();
    }

    @Override
    public void destroy() {
        log.trace((Object)"destroying pool");
        this.pool.destroy();
        this.currentBeanContext.remove();
        this.inUse.getAndSet(0);
    }

    public BeanContext get() {
        BeanContext ctx = this.currentBeanContext.get();
        if (ctx != null) {
            this.currentBeanContext.set(null);
        } else {
            ctx = this.create();
        }
        this.inUse.incrementAndGet();
        return ctx;
    }

    public BeanContext get(Class[] initTypes, Object[] initValues) {
        BeanContext ctx = this.currentBeanContext.get();
        if (ctx != null) {
            this.currentBeanContext.set(null);
        } else {
            ctx = this.create(initTypes, initValues);
        }
        this.inUse.incrementAndGet();
        return ctx;
    }

    @Override
    public void initialize(Container container, int maxSize, long timeout) {
        this.pool.initialize(container, maxSize, timeout);
    }

    public void release(BeanContext ctx) {
        if (this.currentBeanContext.get() != null) {
            this.remove(ctx);
        } else {
            this.currentBeanContext.set(ctx);
        }
        this.inUse.decrementAndGet();
    }

    public void remove(BeanContext ctx) {
        this.pool.remove(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentSize() {
        int size;
        Pool pool = this.pool;
        synchronized (pool) {
            size = this.pool.getCreateCount() - this.pool.getRemoveCount();
        }
        return size;
    }

    @Override
    public int getAvailableCount() {
        return this.getMaxSize() - this.inUse.get();
    }

    @Override
    public int getCreateCount() {
        return this.pool.getCreateCount();
    }

    @Override
    public int getMaxSize() {
        return this.getCurrentSize();
    }

    @Override
    public int getRemoveCount() {
        return this.pool.getRemoveCount();
    }

    @Override
    public void setInjectors(Injector[] injectors) {
        this.pool.setInjectors(injectors);
    }

    @Override
    public void setMaxSize(int maxSize) {
        log.warn((Object)"EJBTHREE-1703: setting a max size on ThreadlocalPool is bogus");
    }
}

