/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.logging.Logger;
import org.jboss.security.RealmMapping;

public abstract class BaseContext<T extends Container>
implements BeanContext<T> {
    protected static Logger log = Logger.getLogger(BaseContext.class);
    protected T container;
    protected Object bean;
    protected RealmMapping rm;
    protected SimpleMetaData metadata;
    protected Map<Class<?>, Object> interceptorInstances = new HashMap();

    protected BaseContext(T container) {
        assert (container != null) : "container is null";
        this.container = container;
    }

    protected BaseContext(T container, Object bean) {
        this(container);
        assert (bean != null) : "bean is null";
        this.bean = bean;
    }

    protected BaseContext() {
    }

    public Object getId() {
        return null;
    }

    @Override
    public Object getInstance() {
        return this.bean;
    }

    @Override
    public T getContainer() {
        return this.container;
    }

    @Override
    public SimpleMetaData getMetaData() {
        if (this.metadata == null) {
            this.metadata = new SimpleMetaData();
        }
        return this.metadata;
    }

    @Override
    public void initialiseInterceptorInstances() {
        try {
            EJBContainer c = (EJBContainer)this.container;
            List<Class<?>> interceptorClasses = c.getBeanContainer().getInterceptorClasses();
            for (Class<?> interceptorClass : interceptorClasses) {
                this.interceptorInstances.put(interceptorClass, c.createInterceptor(interceptorClass));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    @Deprecated
    public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos) {
        Object[] interceptors = new Object[interceptorInfos.length];
        int i = 0;
        for (InterceptorInfo info : interceptorInfos) {
            interceptors[i++] = this.interceptorInstances.get(info.getClazz());
        }
        return interceptors;
    }

    public Object getInvokedMethodKey() {
        return this.container;
    }

    public Object getInterceptor(Class<?> interceptorClass) throws IllegalArgumentException {
        Object interceptor = this.interceptorInstances.get(interceptorClass);
        if (interceptor == null) {
            throw new IllegalArgumentException("No interceptor found for " + interceptorClass + " in " + this);
        }
        return interceptor;
    }
}

