/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.content.yum;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PrimaryMD5 {
    private final File directory;
    private static final ReentrantLock lock = new ReentrantLock();
    private final Log log = LogFactory.getLog(PrimaryMD5.class);

    PrimaryMD5(File directory) {
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String read() throws IOException {
        String content = null;
        BufferedReader reader = null;
        File file = this.file();
        lock.lock();
        try {
            if (file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                content = reader.readLine();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("primary.md5 - read failed\n" + e));
        }
        finally {
            lock.unlock();
            if (reader != null) {
                reader.close();
            }
        }
        return content;
    }

    void write(String content) throws IOException {
        BufferedWriter writer = null;
        lock.lock();
        try {
            writer = new BufferedWriter(new FileWriter(this.file()));
            writer.write(content);
            writer.flush();
            this.log.info((Object)("primary.md5 updated: " + content));
        }
        catch (IOException e) {
            this.log.error((Object)("primary.md5 - update failed\n" + e));
            throw e;
        }
        finally {
            lock.unlock();
            if (writer != null) {
                writer.close();
            }
        }
    }

    void delete() {
        this.file().delete();
    }

    long lastModified() {
        return this.file().lastModified();
    }

    boolean matches(String content) throws IOException {
        return content.equals(this.read());
    }

    private File file() {
        return new File(this.directory, "primary.md5");
    }
}

