/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.util.concurrent.Semaphore;
import org.jboss.marshalling.NioByteInput;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.LocalReplyHandler;
import org.jboss.xnio.Cancellable;

final class OutboundRequest
implements Cancellable {
    private final int cid;
    private final LocalReplyHandler inboundReplyHandler;
    private final Semaphore flowSemaphore = new Semaphore(5);
    private State state = State.SENDING;
    private NioByteInput byteInput;
    private RemoteConnectionHandler remoteConnectionHandler;

    OutboundRequest(RemoteConnectionHandler remoteConnectionHandler, LocalReplyHandler inboundReplyHandler, int cid) {
        this.remoteConnectionHandler = remoteConnectionHandler;
        this.inboundReplyHandler = inboundReplyHandler;
        this.cid = cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State getState() {
        OutboundRequest outboundRequest = this;
        synchronized (outboundRequest) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(State state) {
        OutboundRequest outboundRequest = this;
        synchronized (outboundRequest) {
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cancellable cancel() {
        OutboundRequest outboundRequest = this;
        synchronized (outboundRequest) {
            switch (this.state) {
                case SENDING: {
                    break;
                }
                case REPLY_WAIT: {
                    break;
                }
            }
        }
        return this;
    }

    void setByteInput(NioByteInput byteInput) {
        this.byteInput = byteInput;
    }

    NioByteInput getByteInput() {
        return this.byteInput;
    }

    void ack() {
        this.flowSemaphore.release();
    }

    RemoteConnectionHandler getRemoteConnectionHandler() {
        return this.remoteConnectionHandler;
    }

    public int getClientId() {
        return this.cid;
    }

    public void acquire() throws InterruptedException {
        this.flowSemaphore.acquire();
    }

    LocalReplyHandler getInboundReplyHandler() {
        return this.inboundReplyHandler;
    }

    public String toString() {
        return "Outbound Request for client ID " + this.cid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        SENDING,
        REPLY_WAIT,
        CANCEL_WAIT,
        RECEIVING,
        CLOSED;

    }
}

