/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.spi.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScanningPlugin<T extends ScanningHandle, U>
implements ScanningPlugin<T, U> {
    @Override
    public T createHandle() {
        T handle = this.doCreateHandle();
        if (!this.getHandleInterface().isInstance(handle)) {
            throw new IllegalArgumentException("Illegal handle type: " + handle + " != " + this.getHandleInterface());
        }
        return handle;
    }

    protected abstract T doCreateHandle();

    protected ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanningHandle readHandle(InputStream is) throws Exception {
        try {
            GZIPInputStream gis = new GZIPInputStream(is);
            ObjectInputStream ois = this.createObjectInputStream(gis);
            ScanningHandle scanningHandle = (ScanningHandle)ois.readObject();
            return scanningHandle;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHandle(OutputStream os, T handle) throws IOException {
        GZIPOutputStream gos = new GZIPOutputStream(os);
        ObjectOutputStream oos = new ObjectOutputStream(gos);
        try {
            oos.writeObject(handle);
            oos.flush();
        }
        finally {
            oos.close();
        }
    }

    @Override
    public void cleanupHandle(U handle) {
    }

    @Override
    public String getAttachmentKey() {
        return this.getHandleInterface().getName();
    }

    @Override
    public String getFileName() {
        return this.getHandleInterface().getSimpleName() + ".mcs";
    }

    public boolean accepts(ResourceContext resource) {
        return this.getFilter().accepts(resource);
    }

    @Override
    public ResourceFilter getRecurseFilter() {
        return null;
    }
}

