/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.deploy;

import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.profileservice.management.actions.BasicProfileModificationRequest;
import org.jboss.profileservice.plugins.deploy.TransientProfileActivator;
import org.jboss.profileservice.plugins.deploy.actions.DeploymentAddAction;
import org.jboss.profileservice.plugins.deploy.actions.DeploymentDistributeAction;
import org.jboss.profileservice.plugins.deploy.actions.DeploymentRemoveAction;
import org.jboss.profileservice.plugins.deploy.actions.DeploymentStartAction;
import org.jboss.profileservice.plugins.deploy.actions.DeploymentStopAction;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ActionController;
import org.jboss.profileservice.spi.action.ModificationStatus;
import org.jboss.profileservice.spi.action.ProfileModificationAction;
import org.jboss.profileservice.spi.action.ProfileModificationRequest;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.managed.ManagedProfile;

public abstract class AbstractDeployHandler {
    private ActionController actionController;

    public ActionController getActionController() {
        return this.actionController;
    }

    public void setActionController(ActionController actionController) {
        this.actionController = actionController;
    }

    protected String[] resolveDeploymentNames(String ... names) throws NoSuchDeploymentException {
        HashSet<String> repositoryNames = new HashSet<String>(names.length);
        for (String name : names) {
            String resolvedName = this.resolveDeploymentName(name);
            repositoryNames.add(resolvedName);
        }
        return repositoryNames.toArray(new String[repositoryNames.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addDeployment(DeploymentID dtID, InputStream contentIS) throws Exception {
        BasicProfileModificationRequest actions = new BasicProfileModificationRequest(ProfileModificationType.ADD);
        if (dtID.isCopyContent()) {
            ManagedProfile managed = this.actionController.getManagedProfile(dtID.getProfile());
            if (managed == null || !managed.getProfile().isMutable() || !(managed.getProfile() instanceof MutableProfile)) throw new IllegalStateException("failed to get profile " + dtID.getProfile());
            MutableProfile mutable = (MutableProfile)MutableProfile.class.cast(managed.getProfile());
            ProfileKey key = mutable.getKey();
            DeploymentDistributeAction action = this.createWoraroundDistributeAction(key, dtID, contentIS, mutable);
            if (action == null) {
                action = new DeploymentDistributeAction(mutable, dtID, contentIS, null);
            }
            actions.addAction(key, action);
        } else {
            ManagedProfile managed = this.actionController.getManagedProfile(TransientProfileActivator.getTransientProfileKey());
            if (managed == null || !managed.getProfile().isMutable() || !(managed.getProfile() instanceof MutableProfile)) throw new IllegalStateException("failed to get profile " + TransientProfileActivator.getTransientProfileKey());
            MutableProfile mutable = (MutableProfile)MutableProfile.class.cast(managed.getProfile());
            actions.addAction(mutable.getKey(), (ProfileModificationAction)new DeploymentAddAction(dtID, mutable, null));
        }
        this.checkStatus(this.actionController.perform((ProfileModificationRequest)actions));
    }

    protected abstract DeploymentAction<? extends DeploymentActionContext> createWoraroundDistributeAction(ProfileKey var1, DeploymentID var2, InputStream var3, MutableProfile var4) throws Exception;

    protected void startDeployments(String ... deploymentNames) throws Exception {
        Map<ProfileKey, Set<String>> mappings = this.resolveProfiles(deploymentNames, false, true);
        BasicProfileModificationRequest actions = new BasicProfileModificationRequest(ProfileModificationType.UPDATE);
        for (ProfileKey key : mappings.keySet()) {
            ManagedProfile managed = this.actionController.getManagedProfile(key);
            if (managed == null) {
                throw new NoSuchProfileException(key.getName());
            }
            actions.addAction(key, (ProfileModificationAction)new DeploymentStartAction(managed, (Collection<String>)mappings.get(key), null));
        }
        this.checkStatus(this.actionController.perform((ProfileModificationRequest)actions));
    }

    protected void stopDeployments(String ... deploymentNames) throws Exception {
        Map<ProfileKey, Set<String>> mappings = this.resolveProfiles(deploymentNames, false, true);
        BasicProfileModificationRequest actions = new BasicProfileModificationRequest(ProfileModificationType.UPDATE);
        for (ProfileKey key : mappings.keySet()) {
            ManagedProfile managed = this.actionController.getManagedProfile(key);
            if (managed == null) {
                throw new NoSuchProfileException(key.getName());
            }
            actions.addAction(key, (ProfileModificationAction)new DeploymentStopAction(managed, (Collection<String>)mappings.get(key), null));
        }
        this.checkStatus(this.actionController.perform((ProfileModificationRequest)actions));
    }

    protected void removeDeployments(String ... deploymentNames) throws Exception {
        Map<ProfileKey, Set<String>> mappings = this.resolveProfiles(deploymentNames, true, true);
        BasicProfileModificationRequest actions = new BasicProfileModificationRequest(ProfileModificationType.DELETE);
        for (ProfileKey key : mappings.keySet()) {
            ManagedProfile managed = this.actionController.getManagedProfile(key);
            if (managed == null) {
                throw new NoSuchProfileException(key.getName());
            }
            Set<String> names = mappings.get(key);
            for (String deploymentName : names) {
                DeploymentRemoveAction action = this.createWoraroundRemoveAction(key, managed, deploymentName);
                if (action == null) {
                    action = new DeploymentRemoveAction(managed, deploymentName, null);
                }
                actions.addAction(key, action);
            }
        }
        this.checkStatus(this.actionController.perform((ProfileModificationRequest)actions));
    }

    protected abstract DeploymentAction<? extends DeploymentActionContext> createWoraroundRemoveAction(ProfileKey var1, ManagedProfile var2, String var3) throws Exception;

    Map<ProfileKey, Set<String>> resolveProfiles(String[] deploymentNames, boolean checkMutable, boolean fail) throws NoSuchDeploymentException {
        HashMap<ProfileKey, Set<String>> mapping = new HashMap<ProfileKey, Set<String>>();
        for (String deploymentName : deploymentNames) {
            ProfileKey key = this.resolveProfileForDeployment(deploymentName, checkMutable, fail);
            HashSet<String> names = (HashSet<String>)mapping.get(key);
            if (names == null) {
                names = new HashSet<String>();
                mapping.put(key, names);
            }
            names.add(deploymentName);
        }
        return mapping;
    }

    ProfileKey resolveProfileForDeployment(String deploymentName, boolean checkMutableOnly, boolean fail) throws NoSuchDeploymentException {
        for (ProfileKey key : this.actionController.getActiveProfiles()) {
            ManagedProfile managed = this.actionController.getManagedProfile(key);
            if (managed == null) continue;
            Profile profile = managed.getProfile();
            if (checkMutableOnly && !profile.isMutable() || !profile.hasDeployment(deploymentName)) continue;
            return managed.getProfileKey();
        }
        if (fail) {
            throw new NoSuchDeploymentException(deploymentName);
        }
        return null;
    }

    protected String resolveDeploymentName(String name) throws NoSuchDeploymentException {
        for (ProfileKey key : this.actionController.getActiveProfiles()) {
            Profile profile;
            ManagedProfile managed = this.actionController.getManagedProfile(key);
            if (managed == null || !(profile = managed.getProfile()).hasDeployment(name)) continue;
            ProfileDeployment deployment = profile.getDeployment(name);
            return deployment.getName();
        }
        throw new NoSuchDeploymentException(name);
    }

    protected void checkStatus(ModificationStatus status) throws Exception {
        if (status.isFailed()) {
            Throwable t = status.getFailure();
            if (t instanceof Exception) {
                throw (Exception)Exception.class.cast(t);
            }
            throw new UndeclaredThrowableException(t);
        }
    }
}

