/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.helpers;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.BoundServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BindingService {
    private InetSocketAddress[] addresses;
    private BoundServer<InetSocketAddress, ? extends BoundChannel<InetSocketAddress>> server;
    private List<BoundChannel<InetSocketAddress>> bindings;

    public InetSocketAddress[] getAddresses() {
        return this.addresses;
    }

    public void setAddresses(InetSocketAddress[] addresses) {
        this.addresses = addresses;
    }

    public BoundServer<InetSocketAddress, ? extends BoundChannel<InetSocketAddress>> getServer() {
        return this.server;
    }

    public void setServer(BoundServer<InetSocketAddress, ? extends BoundChannel<InetSocketAddress>> server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        block6: {
            ArrayList<BoundChannel<InetSocketAddress>> bindings = new ArrayList<BoundChannel<InetSocketAddress>>();
            boolean ok = false;
            try {
                for (InetSocketAddress address : this.addresses) {
                    bindings.add((BoundChannel<InetSocketAddress>)this.server.bind((Object)address).get());
                }
                ok = true;
                this.bindings = bindings;
                if (ok) break block6;
            }
            catch (Throwable throwable) {
                if (!ok) {
                    for (BoundChannel boundChannel : bindings) {
                        IoUtils.safeClose((Closeable)boundChannel);
                    }
                }
                throw throwable;
            }
            for (BoundChannel<InetSocketAddress> binding : bindings) {
                IoUtils.safeClose(binding);
            }
        }
    }

    public void stop() {
        List<BoundChannel<InetSocketAddress>> bindings = this.bindings;
        this.bindings = null;
        for (BoundChannel<InetSocketAddress> binding : bindings) {
            IoUtils.safeClose(binding);
        }
    }
}

