/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.abstractrecords;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.RecoveryRecord;
import java.io.IOException;
import java.io.PrintWriter;

public class PersistenceRecord
extends RecoveryRecord {
    public static final int MAX_OBJECT_SIZE = 4096;
    protected boolean shadowMade;
    protected ParticipantStore targetParticipantStore;
    protected OutputObjectState topLevelState;
    protected static boolean classicPrepare = false;
    private static boolean writeOptimisation = false;

    public PersistenceRecord(OutputObjectState os, ParticipantStore participantStore, StateManager sm) {
        super(os, sm);
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("PersistenceRecord::PersistenceRecord(" + os + ", " + sm.get_uid() + ")"));
        }
        this.shadowMade = false;
        this.targetParticipantStore = participantStore;
        this.topLevelState = null;
    }

    @Override
    public int typeIs() {
        return 111;
    }

    @Override
    public int topLevelAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("PersistenceRecord::topLevelAbort() for " + this.order()));
        }
        Uid uid = null;
        String type = null;
        if (this.shadowMade) {
            uid = this.order();
            type = this.getTypeOfObject();
        } else {
            if (this.topLevelState == null) {
                return this.nestedAbort();
            }
            uid = this.topLevelState.stateUid();
            type = this.topLevelState.type();
        }
        try {
            if (!this.targetParticipantStore.remove_uncommitted(uid, type)) {
                tsLogger.i18NLogger.warn_PersistenceRecord_19();
                return 8;
            }
        }
        catch (ObjectStoreException e) {
            tsLogger.i18NLogger.warn_PersistenceRecord_20(e);
            return 8;
        }
        return this.nestedAbort();
    }

    @Override
    public int topLevelCommit() {
        boolean result;
        block12: {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("PersistenceRecord::topLevelCommit() : About to commit state, uid = " + this.order() + ", ObjType = " + this.getTypeOfObject()));
            }
            if (tsLogger.logger.isTraceEnabled()) {
                if (this.targetParticipantStore != null) {
                    tsLogger.logger.trace((Object)(", store = " + this.targetParticipantStore + "(" + this.targetParticipantStore.getClass().getCanonicalName() + ")"));
                } else {
                    tsLogger.logger.trace((Object)"");
                }
            }
            result = false;
            if (this.targetParticipantStore != null) {
                try {
                    if (this.shadowMade) {
                        result = this.targetParticipantStore.commit_state(this.order(), super.getTypeOfObject());
                        if (!result) {
                            tsLogger.i18NLogger.warn_PersistenceRecord_2(this.order());
                        }
                        break block12;
                    }
                    if (this.topLevelState != null) {
                        result = this.targetParticipantStore.write_committed(this.order(), super.getTypeOfObject(), this.topLevelState);
                        break block12;
                    }
                    tsLogger.i18NLogger.warn_PersistenceRecord_3();
                }
                catch (ObjectStoreException e) {
                    tsLogger.i18NLogger.warn_PersistenceRecord_4(e);
                    result = false;
                }
            } else {
                tsLogger.i18NLogger.warn_PersistenceRecord_5();
            }
        }
        if (!result) {
            tsLogger.i18NLogger.warn_PersistenceRecord_6();
        }
        super.forgetAction(true);
        return result ? 7 : 8;
    }

    @Override
    public int topLevelPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("PersistenceRecord::topLevelPrepare() for " + this.order()));
        }
        int result = 1;
        StateManager sm = this.objectAddr;
        if (sm != null && this.targetParticipantStore != null) {
            this.topLevelState = new OutputObjectState(sm.get_uid(), sm.type());
            if (writeOptimisation && !this.targetParticipantStore.fullCommitNeeded() && sm.save_state(this.topLevelState, 1) && this.topLevelState.size() <= 4096) {
                if (classicPrepare) {
                    OutputObjectState dummy = new OutputObjectState(Uid.nullUid(), null);
                    try {
                        this.targetParticipantStore.write_uncommitted(sm.get_uid(), sm.type(), dummy);
                        result = 0;
                    }
                    catch (ObjectStoreException e) {
                        tsLogger.i18NLogger.warn_PersistenceRecord_21(e);
                    }
                    Object var3_3 = null;
                } else {
                    result = 0;
                }
            } else if (sm.deactivate(this.targetParticipantStore.getStoreName(), false)) {
                this.shadowMade = true;
                result = 0;
            } else {
                tsLogger.i18NLogger.warn_PersistenceRecord_7();
            }
        } else {
            tsLogger.i18NLogger.warn_PersistenceRecord_8();
        }
        return result;
    }

    @Override
    public int topLevelCleanup() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("PersistenceRecord::topLevelCleanup() for " + this.order()));
        }
        return 7;
    }

    @Override
    public boolean doSave() {
        return true;
    }

    @Override
    public boolean restore_state(InputObjectState os, int ot) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("PersistenceRecord::restore_state() for " + this.order()));
        }
        boolean res = false;
        this.topLevelState = null;
        try {
            this.shadowMade = os.unpackBoolean();
            if (!this.shadowMade) {
                this.topLevelState = new OutputObjectState(os);
                res = this.topLevelState.valid();
            } else {
                res = true;
            }
            res = res && super.restore_state(os, ot);
            this.targetParticipantStore = this.getStore();
            return res;
        }
        catch (Exception e) {
            tsLogger.i18NLogger.warn_PersistenceRecord_10();
            return res;
        }
    }

    @Override
    public boolean save_state(OutputObjectState os, int ot) {
        boolean res;
        block8: {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("PersistenceRecord::save_state() for " + this.order()));
            }
            res = true;
            if (this.targetParticipantStore != null) {
                try {
                    os.packBoolean(this.shadowMade);
                    if (this.shadowMade) break block8;
                    boolean bl = res = this.topLevelState != null;
                    if (res) {
                        this.topLevelState.packInto(os);
                        break block8;
                    }
                    tsLogger.i18NLogger.warn_PersistenceRecord_14();
                }
                catch (IOException e) {
                    res = false;
                    tsLogger.i18NLogger.warn_PersistenceRecord_15();
                }
            } else {
                tsLogger.i18NLogger.warn_PersistenceRecord_16();
                try {
                    os.packString(null);
                }
                catch (IOException e) {
                    res = false;
                }
            }
        }
        return res && super.save_state(os, ot);
    }

    @Override
    public void print(PrintWriter strm) {
        super.print(strm);
        strm.println("PersistenceRecord with state:\n" + this.state);
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord";
    }

    public PersistenceRecord() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"PersistenceRecord::PersistenceRecord() - crash recovery constructor");
        }
        this.shadowMade = false;
        this.targetParticipantStore = null;
        this.topLevelState = null;
    }

    protected boolean shadowForced() {
        if (this.topLevelState == null) {
            this.shadowMade = true;
            return true;
        }
        return false;
    }

    static {
        classicPrepare = arjPropertyManager.getCoordinatorEnvironmentBean().isClassicPrepare();
        writeOptimisation = arjPropertyManager.getCoordinatorEnvironmentBean().isWriteOptimisation();
    }
}

